/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.scope.internal.jaxrs.feature;

import com.liferay.oauth2.provider.scope.internal.jaxrs.filter.BaseContextContainerRequestFilter;
import com.liferay.oauth2.provider.scope.liferay.OAuth2ProviderScopeLiferayAccessControlContext;
import com.liferay.oauth2.provider.scope.liferay.ScopeContext;
import com.liferay.oauth2.provider.scope.spi.application.descriptor.ApplicationDescriptor;
import com.liferay.oauth2.provider.scope.spi.scope.descriptor.ScopeDescriptor;
import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.service.access.policy.ServiceAccessPolicyThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.Provider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.component.annotations.ServiceScope;
import org.osgi.util.tracker.ServiceTracker;

@Provider
@Component(property={"oauth2.service.access.policy.name=AUTHORIZED_OAUTH2_SAP", "liferay.extension=OAuth2", "osgi.jaxrs.application.select=(!(liferay.oauth2=false))", "osgi.jaxrs.extension=true", "osgi.jaxrs.name=Liferay.OAuth2"}, scope=ServiceScope.PROTOTYPE, service={Feature.class})
public class LiferayOAuth2OSGiFeature
implements Feature {
    protected static final String OAUTH2_SERVICE_ACCESS_POLICY_NAME = "oauth2.service.access.policy.name";
    private static final Log _log = LogFactoryUtil.getLog(LiferayOAuth2OSGiFeature.class);
    @Context
    private Application _application;
    private Bundle _bundle;
    private BundleContext _bundleContext;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(default=true)")
    private volatile ScopeDescriptor _defaultScopeDescriptor;
    private String _oauth2ServiceAccessPolicyName;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile ScopeContext _scopeContext;
    private final Collection<ServiceRegistration<?>> _serviceRegistrations = new ArrayList();
    private final Collection<ServiceTracker<?, ?>> _serviceTrackers = new ArrayList();

    public boolean configure(FeatureContext featureContext) {
        Configuration configuration = featureContext.getConfiguration();
        Map applicationProperties = (Map)configuration.getProperty("osgi.jaxrs.application.serviceProperties");
        Class<?> applicationClass = this._application.getClass();
        final String osgiJaxRsName = MapUtil.getString((Map)applicationProperties, (String)"osgi.jaxrs.name", (String)applicationClass.getName());
        featureContext.register((Object)new BaseContextContainerRequestFilter(){

            public void filter(ContainerRequestContext requestContext) {
                LiferayOAuth2OSGiFeature.this._scopeContext.setApplicationName(osgiJaxRsName);
                LiferayOAuth2OSGiFeature.this._scopeContext.setBundle(LiferayOAuth2OSGiFeature.this._bundle);
                LiferayOAuth2OSGiFeature.this._scopeContext.setCompanyId(this.getCompanyId());
            }
        }, 1990);
        featureContext.register((a, b) -> this._scopeContext.clear(), 1991);
        String oauth2ServiceAccessPolicyName = MapUtil.getString((Map)applicationProperties, (String)OAUTH2_SERVICE_ACCESS_POLICY_NAME, (String)this._oauth2ServiceAccessPolicyName);
        featureContext.register(a -> {
            if (OAuth2ProviderScopeLiferayAccessControlContext.isOAuth2AuthVerified()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Enabling SAP " + oauth2ServiceAccessPolicyName));
                }
                ServiceAccessPolicyThreadLocal.addActiveServiceAccessPolicyName((String)oauth2ServiceAccessPolicyName);
            }
        }, 1991);
        this.registerDescriptors(osgiJaxRsName);
        return true;
    }

    @Activate
    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        this._bundle = componentContext.getUsingBundle();
        this._bundleContext = componentContext.getBundleContext();
        this._oauth2ServiceAccessPolicyName = MapUtil.getString(properties, (String)OAUTH2_SERVICE_ACCESS_POLICY_NAME);
    }

    @Deactivate
    protected void deactivate() {
        for (ServiceRegistration<?> serviceRegistration : this._serviceRegistrations) {
            try {
                serviceRegistration.unregister();
            }
            catch (Exception exception) {}
        }
        for (ServiceTracker serviceTracker : this._serviceTrackers) {
            serviceTracker.close();
        }
    }

    protected void registerDescriptors(String osgiJaxRsName) {
        String bundleSymbolicName = this._bundle.getSymbolicName();
        StringBundler sb = new StringBundler(5);
        sb.append("(&(bundle.symbolic.name=");
        sb.append(bundleSymbolicName);
        sb.append(")(objectClass=");
        sb.append(ResourceBundleLoader.class.getName());
        sb.append(")(resource.bundle.base.name=content.Language))");
        ServiceTracker serviceTracker = ServiceTrackerFactory.open((BundleContext)this._bundleContext, (String)sb.toString());
        this._serviceTrackers.add(serviceTracker);
        HashMapDictionary properties = new HashMapDictionary();
        properties.put("osgi.jaxrs.name", osgiJaxRsName);
        this._serviceRegistrations.add(this._bundleContext.registerService(new String[]{ScopeDescriptor.class.getName(), ApplicationDescriptor.class.getName()}, (Object)new ApplicationDescriptorsImpl(serviceTracker, osgiJaxRsName), (Dictionary)properties));
    }

    private class ApplicationDescriptorsImpl
    implements ScopeDescriptor,
    ApplicationDescriptor {
        private final String _osgiJaxRsName;
        private final ServiceTracker<?, ResourceBundleLoader> _serviceTracker;

        public ApplicationDescriptorsImpl(ServiceTracker<?, ResourceBundleLoader> serviceTracker, String osgiJaxRsName) {
            this._serviceTracker = serviceTracker;
            this._osgiJaxRsName = osgiJaxRsName;
        }

        public String describeApplication(Locale locale) {
            ResourceBundleLoader resourceBundleLoader = (ResourceBundleLoader)this._serviceTracker.getService();
            if (resourceBundleLoader == null) {
                return this._osgiJaxRsName;
            }
            String key = "oauth2.application.description." + this._osgiJaxRsName;
            return GetterUtil.getString((String)ResourceBundleUtil.getString((ResourceBundle)resourceBundleLoader.loadResourceBundle(locale), (String)key), (String)key);
        }

        public String describeScope(String scope, Locale locale) {
            ResourceBundleLoader resourceBundleLoader = (ResourceBundleLoader)this._serviceTracker.getService();
            if (resourceBundleLoader == null) {
                return LiferayOAuth2OSGiFeature.this._defaultScopeDescriptor.describeScope(scope, locale);
            }
            String key = "oauth2.scope." + scope;
            return GetterUtil.getString((String)ResourceBundleUtil.getString((ResourceBundle)resourceBundleLoader.loadResourceBundle(locale), (String)key), (String)LiferayOAuth2OSGiFeature.this._defaultScopeDescriptor.describeScope(scope, locale));
        }
    }
}

