/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.scope.internal.spi.scope.matcher;

import com.liferay.oauth2.provider.scope.spi.scope.matcher.ScopeMatcher;
import com.liferay.oauth2.provider.scope.spi.scope.matcher.ScopeMatcherFactory;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(property={"default=true", "delimiter=.", "type=chunks"}, service={ScopeMatcherFactory.class})
public class ChunkScopeMatcherFactory
implements ScopeMatcherFactory {
    private String _delimiter = ".";

    public ScopeMatcher create(String input) {
        String[] inputParts = StringUtil.split((String)input, (String)this._delimiter);
        if (inputParts.length == 0) {
            return ScopeMatcher.NONE;
        }
        return new ChunkScopeMatcher(inputParts);
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._delimiter = MapUtil.getString(properties, (String)"delimiter", (String)".");
    }

    private class ChunkScopeMatcher
    implements ScopeMatcher {
        private final String[] _inputParts;

        public boolean match(String name) {
            String[] nameParts = StringUtil.split((String)name, (String)ChunkScopeMatcherFactory.this._delimiter);
            if (nameParts.length < this._inputParts.length) {
                return false;
            }
            for (int i = 0; i < this._inputParts.length; ++i) {
                if (this._inputParts[i].equals(nameParts[i])) continue;
                return false;
            }
            return true;
        }

        private ChunkScopeMatcher(String[] inputParts) {
            this._inputParts = inputParts;
        }
    }
}

