/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.scope.internal;

import com.liferay.oauth2.provider.model.OAuth2ScopeGrant;
import com.liferay.oauth2.provider.scope.ScopeChecker;
import com.liferay.oauth2.provider.scope.liferay.ScopeContext;
import com.liferay.oauth2.provider.service.OAuth2ScopeGrantLocalService;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={ScopeChecker.class, ScopeContext.class})
public class ThreadLocalScopeContextScopeChecker
implements ScopeChecker,
ScopeContext {
    private final ThreadLocal<String> _accessTokenThreadLocal = ThreadLocal.withInitial(() -> "");
    private final ThreadLocal<String> _applicationNameThreadLocal = ThreadLocal.withInitial(() -> "");
    private final ThreadLocal<String> _bundleSymbolicNameThreadLocal = ThreadLocal.withInitial(() -> "");
    private final ThreadLocal<Long> _companyIdThreadLocal = ThreadLocal.withInitial(() -> 0L);
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile OAuth2ScopeGrantLocalService _oAuth2ScopeGrantLocalService;

    public boolean checkAllScopes(String ... scopes) {
        if (Validator.isNull((Object)scopes)) {
            throw new IllegalArgumentException("Scopes are null");
        }
        ArrayList<OAuth2ScopeGrant> oAuth2ScopeGrants = new ArrayList<OAuth2ScopeGrant>(this._oAuth2ScopeGrantLocalService.getOAuth2ScopeGrants(this._companyIdThreadLocal.get().longValue(), this._applicationNameThreadLocal.get(), this._bundleSymbolicNameThreadLocal.get(), this._accessTokenThreadLocal.get()));
        if (scopes.length > oAuth2ScopeGrants.size()) {
            return false;
        }
        for (String scope : scopes) {
            if (Validator.isNull((String)scope)) {
                throw new IllegalArgumentException("Scope is null");
            }
            if (oAuth2ScopeGrants.removeIf(o -> scope.equals(o.getScope()))) continue;
            return false;
        }
        return true;
    }

    public boolean checkAnyScope(String ... scopes) {
        if (Validator.isNull((Object)scopes)) {
            throw new IllegalArgumentException("Scopes are null");
        }
        Collection oAuth2ScopeGrants = this._oAuth2ScopeGrantLocalService.getOAuth2ScopeGrants(this._companyIdThreadLocal.get().longValue(), this._applicationNameThreadLocal.get(), this._bundleSymbolicNameThreadLocal.get(), this._accessTokenThreadLocal.get());
        for (String scope : scopes) {
            if (Validator.isNull((String)scope)) {
                throw new IllegalArgumentException("Scope is null");
            }
            for (OAuth2ScopeGrant oAuth2ScopeGrant : oAuth2ScopeGrants) {
                if (!scope.equals(oAuth2ScopeGrant.getScope())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean checkScope(String scope) {
        if (Validator.isNull((String)scope)) {
            throw new IllegalArgumentException("Scope is null");
        }
        Collection oAuth2ScopeGrants = this._oAuth2ScopeGrantLocalService.getOAuth2ScopeGrants(this._companyIdThreadLocal.get().longValue(), this._applicationNameThreadLocal.get(), this._bundleSymbolicNameThreadLocal.get(), this._accessTokenThreadLocal.get());
        for (OAuth2ScopeGrant oAuth2ScopeGrant : oAuth2ScopeGrants) {
            if (!scope.equals(oAuth2ScopeGrant.getScope())) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this._accessTokenThreadLocal.remove();
        this._applicationNameThreadLocal.remove();
        this._bundleSymbolicNameThreadLocal.remove();
        this._companyIdThreadLocal.remove();
    }

    public void setAccessToken(String accessToken) {
        this._accessTokenThreadLocal.set(accessToken);
    }

    public void setApplicationName(String applicationName) {
        this._applicationNameThreadLocal.set(applicationName);
    }

    public void setBundle(Bundle bundle) {
        this._bundleSymbolicNameThreadLocal.set(bundle.getSymbolicName());
    }

    public void setCompanyId(long companyId) {
        this._companyIdThreadLocal.set(companyId);
    }
}

