/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import javax.crypto.SecretKey;
import org.apache.cxf.rs.security.jose.jwa.AlgorithmUtils;
import org.apache.cxf.rs.security.jose.jwa.KeyAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.WrappedKeyDecryptionAlgorithm;
import org.apache.cxf.rt.security.crypto.CryptoUtils;

public class AesWrapKeyDecryptionAlgorithm
extends WrappedKeyDecryptionAlgorithm {
    public AesWrapKeyDecryptionAlgorithm(String encodedKey) {
        this(encodedKey, KeyAlgorithm.A128KW);
    }

    public AesWrapKeyDecryptionAlgorithm(String encodedKey, KeyAlgorithm supportedAlgo) {
        this(CryptoUtils.decodeSequence(encodedKey), supportedAlgo);
    }

    public AesWrapKeyDecryptionAlgorithm(byte[] secretKey) {
        this(secretKey, KeyAlgorithm.A128KW);
    }

    public AesWrapKeyDecryptionAlgorithm(byte[] secretKey, KeyAlgorithm supportedAlgo) {
        this(CryptoUtils.createSecretKeySpec(secretKey, "AESWrap"), supportedAlgo);
    }

    public AesWrapKeyDecryptionAlgorithm(SecretKey secretKey) {
        this(secretKey, null);
    }

    public AesWrapKeyDecryptionAlgorithm(SecretKey secretKey, KeyAlgorithm supportedAlgo) {
        super(secretKey, supportedAlgo);
    }

    @Override
    protected void validateKeyEncryptionAlgorithm(String keyAlgo) {
        super.validateKeyEncryptionAlgorithm(keyAlgo);
        if (!this.isValidAlgorithmFamily(keyAlgo)) {
            this.reportInvalidKeyAlgorithm(keyAlgo);
        }
    }

    protected boolean isValidAlgorithmFamily(String keyAlgo) {
        return AlgorithmUtils.isAesKeyWrap(keyAlgo);
    }
}

