/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.scope.logic;

import com.liferay.oauth2.provider.rest.internal.scope.logic.ScopeLogic;
import com.liferay.oauth2.provider.scope.ScopeChecker;
import com.liferay.oauth2.provider.scope.spi.scope.finder.ScopeFinder;
import com.liferay.osgi.util.StringPlus;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.ws.rs.HttpMethod;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(property={"ignore.missing.scopes=HEAD", "ignore.missing.scopes=OPTIONS", "oauth2.scope.checker.type=http.method"}, service={HttpMethodScopeLogic.class, ScopeLogic.class})
public class HttpMethodScopeLogic
implements ScopeLogic {
    private static final Log _log = LogFactoryUtil.getLog(HttpMethodScopeLogic.class);
    private BundleContext _bundleContext;
    private Set<String> _ignoreMissingScopes;

    @Override
    public boolean check(Function<String, Object> propertyAccessorFunction, Class<?> resourceClass, Method resourceMethod, ScopeChecker scopeChecker) {
        return this.check(propertyAccessorFunction, this._getHttpMethod(resourceMethod), scopeChecker);
    }

    public boolean check(Function<String, Object> propertyAccessorFunction, String requestMethod, ScopeChecker scopeChecker) {
        block4: {
            try {
                ScopeFinder scopeFinder;
                Collection scopes;
                String applicationName = GetterUtil.getString((Object)propertyAccessorFunction.apply("osgi.jaxrs.name"));
                Object ignoreMissingScopesObject = propertyAccessorFunction.apply("ignore.missing.scopes");
                Set<String> ignoreMissingScopes = this._ignoreMissingScopes;
                if (ignoreMissingScopesObject != null) {
                    ignoreMissingScopes = new HashSet<String>(StringPlus.asList((Object)ignoreMissingScopesObject));
                }
                if (!(scopes = (scopeFinder = (ScopeFinder)this._bundleContext.getService(this._getServiceReference(applicationName, ScopeFinder.class))).findScopes()).contains(requestMethod) && ignoreMissingScopes.contains(requestMethod) || scopeChecker.checkScope(requestMethod)) {
                    return true;
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Throwable)exception);
            }
        }
        return false;
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._bundleContext = bundleContext;
        this._ignoreMissingScopes = new HashSet<String>(StringPlus.asList((Object)properties.get("ignore.missing.scopes")));
    }

    private String _getHttpMethod(Method method) {
        while (method != null) {
            for (Annotation annotation : method.getAnnotations()) {
                HttpMethod[] httpMethodArray;
                int n;
                int n2;
                Class<? extends Annotation> annotationType = annotation.annotationType();
                HttpMethod[] annotationsByType = (HttpMethod[])annotationType.getAnnotationsByType(HttpMethod.class);
                if (annotationsByType == null || (n2 = 0) >= (n = (httpMethodArray = annotationsByType).length)) continue;
                HttpMethod httpMethod = httpMethodArray[n2];
                return httpMethod.value();
            }
            method = this._getSuperMethod(method);
        }
        throw new UnsupportedOperationException();
    }

    private <T> ServiceReference<? extends T> _getServiceReference(String applicationName, Class<? extends T> clazz) throws Exception {
        List serviceReferences = (List)this._bundleContext.getServiceReferences(clazz, "(osgi.jaxrs.name=" + applicationName + ")");
        if (ListUtil.isNotEmpty((List)serviceReferences)) {
            return (ServiceReference)serviceReferences.get(0);
        }
        throw new UnsupportedOperationException("Invalid JAX-RS application " + applicationName);
    }

    private Method _getSuperMethod(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        if ((clazz = clazz.getSuperclass()) == Object.class) {
            return null;
        }
        try {
            return clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)noSuchMethodException);
            }
            return null;
        }
    }
}

