/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.endpoint.authorize.message.body;

import com.liferay.oauth2.provider.rest.internal.endpoint.authorize.configuration.AuthorizeScreenConfiguration;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseMessageBodyWriter<T>
implements MessageBodyWriter<T> {
    @Reference
    protected ConfigurationProvider configurationProvider;
    @Context
    protected MessageContext messageContext;
    @Reference
    protected Portal portal;
    private static final Log _log = LogFactoryUtil.getLog(BaseMessageBodyWriter.class);

    public long getSize(T t, Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(T t, Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> multivaluedMap, OutputStream outputStream) throws WebApplicationException {
        HttpServletRequest httpServletRequest = this.messageContext.getHttpServletRequest();
        String authorizeScreenURL = null;
        try {
            authorizeScreenURL = this._getAuthorizeScreenURL(this.portal.getCompanyId(httpServletRequest));
        }
        catch (ConfigurationException configurationException) {
            _log.error((Object)"Unable to get authorize screen configuration", (Throwable)configurationException);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build());
        }
        if (!HttpComponentsUtil.hasDomain((String)authorizeScreenURL)) {
            String portalURL = this.portal.getPortalURL(httpServletRequest);
            authorizeScreenURL = portalURL + authorizeScreenURL;
        }
        authorizeScreenURL = this.writeTo(t, authorizeScreenURL);
        this.messageContext.put((Object)"http.request.redirected", (Object)Boolean.TRUE);
        HttpServletResponse httpServletResponse = this.messageContext.getHttpServletResponse();
        try {
            httpServletResponse.sendRedirect(authorizeScreenURL);
        }
        catch (IOException ioException) {
            throw new WebApplicationException((Throwable)ioException);
        }
    }

    protected String removeParameter(String url, String name) {
        return HttpComponentsUtil.removeParameter((String)url, (String)("oauth2_" + name));
    }

    protected String setParameter(String url, String name, String value) {
        if (Validator.isBlank((String)value)) {
            return url;
        }
        return HttpComponentsUtil.addParameter((String)url, (String)("oauth2_" + name), (String)value);
    }

    protected abstract String writeTo(T var1, String var2);

    private String _getAuthorizeScreenURL(long companyId) throws ConfigurationException {
        AuthorizeScreenConfiguration authorizeScreenConfiguration = (AuthorizeScreenConfiguration)this.configurationProvider.getConfiguration(AuthorizeScreenConfiguration.class, (SettingsLocator)new CompanyServiceSettingsLocator(companyId, AuthorizeScreenConfiguration.class.getName()));
        return authorizeScreenConfiguration.authorizeScreenURL();
    }
}

