/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.endpoint.authorize.container.request.filter;

import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.rest.internal.endpoint.authorize.configuration.AuthorizeScreenConfiguration;
import com.liferay.oauth2.provider.service.OAuth2ApplicationLocalService;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.servlet.ProtectedPrincipal;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.net.URI;
import java.security.Principal;
import java.util.List;
import java.util.Objects;
import javax.annotation.Priority;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.security.SecurityContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@PreMatching
@Priority(value=1000)
@Provider
@Component(property={"osgi.jaxrs.application.select=(osgi.jaxrs.name=Liferay.OAuth2.Application)", "osgi.jaxrs.extension=true", "osgi.jaxrs.name=AuthorizationCodeGrantServiceContainerRequestFilter"}, service={ContainerRequestFilter.class})
public class AuthorizationCodeGrantServiceContainerRequestFilter
implements ContainerRequestFilter {
    private static final Log _log = LogFactoryUtil.getLog(AuthorizationCodeGrantServiceContainerRequestFilter.class);
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Context
    private HttpServletRequest _httpServletRequest;
    @Reference
    private OAuth2ApplicationLocalService _oAuth2ApplicationLocalService;
    @Reference(target="(model.class.name=com.liferay.oauth2.provider.model.OAuth2Application)")
    private ModelResourcePermission<OAuth2Application> _oAuth2ApplicationModelResourcePermission;
    @Reference
    private PermissionCheckerFactory _permissionCheckerFactory;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    public void filter(ContainerRequestContext containerRequestContext) {
        UriInfo uriInfo = containerRequestContext.getUriInfo();
        if (!StringUtil.startsWith((String)uriInfo.getPath(), (String)"authorize")) {
            return;
        }
        User user = this._getUser();
        String clientId = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"client_id");
        OAuth2Application oAuth2Application = this._oAuth2ApplicationLocalService.fetchOAuth2Application(user.getCompanyId(), clientId);
        boolean promptNone = this._isPromptNone(oAuth2Application);
        try {
            boolean guestAuthorized = false;
            if (user.isDefaultUser() && !Validator.isBlank((String)clientId)) {
                guestAuthorized = this._containsOAuth2ApplicationViewPermission(oAuth2Application, user);
            }
            if (!user.isDefaultUser() || guestAuthorized) {
                final long userId = user.getUserId();
                containerRequestContext.setSecurityContext((javax.ws.rs.core.SecurityContext)new PortalCXFSecurityContext(){

                    public Principal getUserPrincipal() {
                        return new ProtectedPrincipal(String.valueOf(userId));
                    }

                    public boolean isSecure() {
                        return AuthorizationCodeGrantServiceContainerRequestFilter.this._portal.isSecure(AuthorizationCodeGrantServiceContainerRequestFilter.this._httpServletRequest);
                    }
                });
                return;
            }
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to resolve authenticated user", (Throwable)exception);
            if (promptNone) {
                this._abortWithoutPrompt(containerRequestContext, "interaction_required", oAuth2Application);
            } else {
                containerRequestContext.abortWith(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build());
            }
            return;
        }
        if (promptNone) {
            this._abortWithoutPrompt(containerRequestContext, "login_required", oAuth2Application);
            return;
        }
        String loginURL = null;
        try {
            loginURL = this._getLoginURL();
        }
        catch (ConfigurationException configurationException) {
            _log.error((Object)"Unable to locate configuration", (Throwable)configurationException);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build());
        }
        URI requestURI = uriInfo.getRequestUri();
        String requestURIString = requestURI.toASCIIString();
        String portalURL = this._portal.getPortalURL(this._httpServletRequest);
        if (requestURIString.startsWith(portalURL)) {
            requestURIString = requestURIString.substring(portalURL.length());
        }
        requestURIString = requestURIString.replaceFirst("\\?.*", StringUtil.replace((String)("?" + requestURI.getRawQuery()), (char)':', (String)"%3a"));
        loginURL = HttpComponentsUtil.addParameter((String)loginURL, (String)"redirect", (String)requestURIString);
        containerRequestContext.abortWith(Response.status((Response.Status)Response.Status.FOUND).location(URI.create(loginURL)).build());
    }

    private void _abortWithoutPrompt(ContainerRequestContext containerRequestContext, String error, OAuth2Application oAuth2Application) {
        if (oAuth2Application == null) {
            return;
        }
        StringBundler sb = new StringBundler(5);
        List redirectURIsList = oAuth2Application.getRedirectURIsList();
        sb.append((String)redirectURIsList.get(0));
        sb.append("?error=");
        sb.append(error);
        String state = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"state");
        if (Validator.isNotNull((String)state)) {
            sb.append("&state=");
            sb.append(state);
        }
        containerRequestContext.abortWith(Response.temporaryRedirect((URI)URI.create(sb.toString())).build());
    }

    private boolean _containsOAuth2ApplicationViewPermission(OAuth2Application oAuth2Application, User user) throws Exception {
        if (oAuth2Application == null) {
            return false;
        }
        return this._oAuth2ApplicationModelResourcePermission.contains(this._permissionCheckerFactory.create(user), (ClassedModel)oAuth2Application, "VIEW");
    }

    private String _getLoginURL() throws ConfigurationException {
        AuthorizeScreenConfiguration authorizeScreenConfiguration = (AuthorizeScreenConfiguration)this._configurationProvider.getConfiguration(AuthorizeScreenConfiguration.class, (SettingsLocator)new CompanyServiceSettingsLocator(this._portal.getCompanyId(this._httpServletRequest), AuthorizeScreenConfiguration.class.getName()));
        String loginURL = authorizeScreenConfiguration.loginURL();
        if (Validator.isBlank((String)loginURL)) {
            loginURL = StringBundler.concat((String[])new String[]{this._portal.getPortalURL(this._httpServletRequest), this._portal.getPathContext(), this._portal.getPathMain(), "/portal/login"});
        } else if (!HttpComponentsUtil.hasDomain((String)loginURL)) {
            String portalURL = this._portal.getPortalURL(this._httpServletRequest);
            loginURL = portalURL + loginURL;
        }
        return loginURL;
    }

    private User _getUser() {
        try {
            User user = this._portal.getUser(this._httpServletRequest);
            if (user == null) {
                user = this._userLocalService.getDefaultUser(this._portal.getCompanyId(this._httpServletRequest));
            }
            return user;
        }
        catch (PortalException portalException) {
            return (User)ReflectionUtil.throwException((Throwable)portalException);
        }
    }

    private boolean _isPromptNone(OAuth2Application oAuth2Application) {
        if (oAuth2Application == null) {
            return false;
        }
        String prompt = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"prompt");
        return oAuth2Application.isTrustedApplication() && Objects.equals("none", prompt);
    }

    private static abstract class PortalCXFSecurityContext
    implements SecurityContext,
    javax.ws.rs.core.SecurityContext {
        private PortalCXFSecurityContext() {
        }

        public String getAuthenticationScheme() {
            return "session";
        }

        public boolean isUserInRole(String role) {
            return false;
        }
    }
}

