/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.client;

import com.liferay.oauth.client.LocalOAuthClient;
import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.rest.internal.endpoint.liferay.LiferayOAuthDataProvider;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenRegistration;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={LocalOAuthClient.class})
public class LocalOAuthClientImpl
implements LocalOAuthClient {
    private static final Log _log = LogFactoryUtil.getLog(LocalOAuthClientImpl.class);
    @Reference
    private LiferayOAuthDataProvider _liferayOAuthDataProvider;

    public void consumeAccessToken(Consumer<String> accessTokenConsumer, OAuth2Application oAuth2Application, long userId) {
        ServerAccessToken serverAccessToken = this._getServerAccessToken(oAuth2Application, userId);
        accessTokenConsumer.accept(serverAccessToken.getTokenKey());
    }

    public String requestTokens(OAuth2Application oAuth2Application, long userId) {
        try {
            ServerAccessToken serverAccessToken = this._getServerAccessToken(oAuth2Application, userId);
            return JSONUtil.put((String)"access_token", (Object)serverAccessToken.getTokenKey()).put("expires_in", serverAccessToken.getExpiresIn()).put("refresh_token", serverAccessToken.getRefreshToken()).put("scope", OAuthUtils.convertPermissionsToScope(serverAccessToken.getScopes())).put("token_type", serverAccessToken.getTokenType()).toString();
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)exception);
            }
            return null;
        }
    }

    private ServerAccessToken _getServerAccessToken(OAuth2Application oAuth2Application, long userId) {
        AccessTokenRegistration accessTokenRegistration = new AccessTokenRegistration();
        Client client = this._liferayOAuthDataProvider.getClient(oAuth2Application);
        accessTokenRegistration.setApprovedScope(client.getRegisteredScopes());
        accessTokenRegistration.setAudiences(Collections.singletonList(oAuth2Application.getHomePageURL()));
        accessTokenRegistration.setClient(client);
        List allowedGrantTypesList = oAuth2Application.getAllowedGrantTypesList();
        accessTokenRegistration.setGrantType(String.valueOf(allowedGrantTypesList.get(0)));
        accessTokenRegistration.setRequestedScope(client.getRegisteredScopes());
        accessTokenRegistration.setSubject(this._liferayOAuthDataProvider.getUserSubject(userId));
        return this._liferayOAuthDataProvider.createAccessToken(accessTokenRegistration);
    }
}

