/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.provider;

import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.oauth2.common.OAuthRedirectionState;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.provider.SessionAuthenticityTokenProvider;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;
import org.apache.cxf.rs.security.oauth2.utils.crypto.ModelEncryptionSupport;

public class JoseSessionTokenProvider
implements SessionAuthenticityTokenProvider {
    private JwsSignatureProvider jwsProvider;
    private JwsSignatureVerifier jwsVerifier;
    private JweEncryptionProvider jweEncryptor;
    private JweDecryptionProvider jweDecryptor;
    private boolean jwsRequired;
    private boolean jweRequired;
    private int maxDefaultSessionInterval;

    @Override
    public String createSessionToken(MessageContext mc, MultivaluedMap<String, String> params, UserSubject subject, OAuthRedirectionState secData) {
        String stateString = this.convertStateToString(secData);
        String sessionToken = this.protectStateString(stateString);
        return OAuthUtils.setSessionToken(mc, sessionToken, this.maxDefaultSessionInterval);
    }

    @Override
    public String getSessionToken(MessageContext mc, MultivaluedMap<String, String> params, UserSubject subject) {
        return OAuthUtils.getSessionToken(mc);
    }

    @Override
    public String removeSessionToken(MessageContext mc, MultivaluedMap<String, String> params, UserSubject subject) {
        return this.getSessionToken(mc, params, subject);
    }

    @Override
    public OAuthRedirectionState getSessionState(MessageContext messageContext, String sessionToken, UserSubject subject) {
        String stateString = this.decryptStateString(sessionToken);
        return this.convertStateStringToState(stateString);
    }

    public void setJwsProvider(JwsSignatureProvider jwsProvider) {
        this.jwsProvider = jwsProvider;
    }

    public void setJwsVerifier(JwsSignatureVerifier jwsVerifier) {
        this.jwsVerifier = jwsVerifier;
    }

    public void setJweEncryptor(JweEncryptionProvider jweEncryptor) {
        this.jweEncryptor = jweEncryptor;
    }

    public void setJweDecryptor(JweDecryptionProvider jweDecryptor) {
        this.jweDecryptor = jweDecryptor;
    }

    protected JwsSignatureProvider getInitializedSigProvider() {
        if (this.jwsProvider != null) {
            return this.jwsProvider;
        }
        return JwsUtils.loadSignatureProvider(this.jwsRequired);
    }

    protected JweEncryptionProvider getInitializedEncryptionProvider() {
        if (this.jweEncryptor != null) {
            return this.jweEncryptor;
        }
        return JweUtils.loadEncryptionProvider(this.jweRequired);
    }

    public void setJwsRequired(boolean jwsRequired) {
        this.jwsRequired = jwsRequired;
    }

    public void setJweRequired(boolean jweRequired) {
        this.jweRequired = jweRequired;
    }

    protected JweDecryptionProvider getInitializedDecryptionProvider() {
        if (this.jweDecryptor != null) {
            return this.jweDecryptor;
        }
        return JweUtils.loadDecryptionProvider(this.jweRequired);
    }

    protected JwsSignatureVerifier getInitializedSigVerifier() {
        if (this.jwsVerifier != null) {
            return this.jwsVerifier;
        }
        return JwsUtils.loadSignatureVerifier(this.jwsRequired);
    }

    private String decryptStateString(String sessionToken) {
        JweDecryptionProvider jwe = this.getInitializedDecryptionProvider();
        String stateString = jwe.decrypt(sessionToken).getContentText();
        JwsSignatureVerifier jws = this.getInitializedSigVerifier();
        if (jws != null) {
            stateString = JwsUtils.verify(jws, stateString).getDecodedJwsPayload();
        }
        return stateString;
    }

    private String protectStateString(String stateString) {
        JwsSignatureProvider jws = this.getInitializedSigProvider();
        JweEncryptionProvider jwe = this.getInitializedEncryptionProvider();
        if (jws == null && jwe == null) {
            throw new OAuthServiceException("Session token can not be created");
        }
        if (jws != null) {
            stateString = JwsUtils.sign(jws, stateString, null);
        }
        if (jwe != null) {
            stateString = jwe.encrypt(StringUtils.toBytesUTF8((String)stateString), null);
        }
        return stateString;
    }

    private OAuthRedirectionState convertStateStringToState(String stateString) {
        String[] parts = ModelEncryptionSupport.getParts(stateString);
        OAuthRedirectionState state = new OAuthRedirectionState();
        if (!StringUtils.isEmpty((String)parts[0])) {
            state.setClientId(parts[0]);
        }
        if (!StringUtils.isEmpty((String)parts[1])) {
            state.setAudience(parts[1]);
        }
        if (!StringUtils.isEmpty((String)parts[2])) {
            state.setClientCodeChallenge(parts[2]);
        }
        if (!StringUtils.isEmpty((String)parts[3])) {
            state.setState(parts[3]);
        }
        if (!StringUtils.isEmpty((String)parts[4])) {
            state.setProposedScope(parts[4]);
        }
        if (!StringUtils.isEmpty((String)parts[5])) {
            state.setRedirectUri(parts[5]);
        }
        if (!StringUtils.isEmpty((String)parts[6])) {
            state.setNonce(parts[6]);
        }
        if (!StringUtils.isEmpty((String)parts[7])) {
            state.setResponseType(parts[7]);
        }
        if (!StringUtils.isEmpty((String)parts[8])) {
            state.setExtraProperties(ModelEncryptionSupport.parseSimpleMap(parts[8]));
        }
        return state;
    }

    protected String convertStateToString(OAuthRedirectionState secData) {
        StringBuilder state = new StringBuilder();
        state.append(ModelEncryptionSupport.tokenizeString(secData.getClientId()));
        state.append("|");
        state.append(ModelEncryptionSupport.tokenizeString(secData.getAudience()));
        state.append("|");
        state.append(ModelEncryptionSupport.tokenizeString(secData.getClientCodeChallenge()));
        state.append("|");
        state.append(ModelEncryptionSupport.tokenizeString(secData.getState()));
        state.append("|");
        state.append(ModelEncryptionSupport.tokenizeString(secData.getProposedScope()));
        state.append("|");
        state.append(ModelEncryptionSupport.tokenizeString(secData.getRedirectUri()));
        state.append("|");
        state.append(ModelEncryptionSupport.tokenizeString(secData.getNonce()));
        state.append("|");
        state.append(ModelEncryptionSupport.tokenizeString(secData.getResponseType()));
        state.append("|");
        state.append(secData.getExtraProperties().toString());
        return state.toString();
    }

    public void setMaxDefaultSessionInterval(int maxDefaultSessionInterval) {
        this.maxDefaultSessionInterval = maxDefaultSessionInterval;
    }
}

