/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import org.apache.cxf.rs.security.jose.jwa.AlgorithmUtils;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jws.AbstractJwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.JwsException;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsSignature;
import org.apache.cxf.rt.security.crypto.CryptoUtils;

public class PrivateKeyJwsSignatureProvider
extends AbstractJwsSignatureProvider {
    private PrivateKey key;
    private SecureRandom random;
    private AlgorithmParameterSpec signatureSpec;

    public PrivateKeyJwsSignatureProvider(PrivateKey key, SignatureAlgorithm algo) {
        this(key, null, algo);
    }

    public PrivateKeyJwsSignatureProvider(PrivateKey key, AlgorithmParameterSpec spec, SignatureAlgorithm algo) {
        this(key, null, spec, algo);
    }

    public PrivateKeyJwsSignatureProvider(PrivateKey key, SecureRandom random, AlgorithmParameterSpec spec, SignatureAlgorithm algo) {
        super(algo);
        this.key = key;
        this.random = random;
        this.signatureSpec = spec;
    }

    @Override
    protected JwsSignature doCreateJwsSignature(JwsHeaders headers) {
        String sigAlgo = headers.getSignatureAlgorithm().getJwaName();
        Signature s = CryptoUtils.getSignature(this.key, AlgorithmUtils.toJavaName(sigAlgo), this.random, this.signatureSpec);
        return this.doCreateJwsSignature(s);
    }

    protected JwsSignature doCreateJwsSignature(Signature s) {
        return new PrivateKeyJwsSignature(s);
    }

    @Override
    protected boolean isValidAlgorithmFamily(String algo) {
        return AlgorithmUtils.isRsaSign(algo);
    }

    protected static class PrivateKeyJwsSignature
    implements JwsSignature {
        private Signature s;

        public PrivateKeyJwsSignature(Signature s) {
            this.s = s;
        }

        @Override
        public void update(byte[] src, int off, int len) {
            try {
                this.s.update(src, off, len);
            }
            catch (SignatureException ex) {
                throw new JwsException(JwsException.Error.SIGNATURE_FAILURE, (Throwable)ex);
            }
        }

        @Override
        public byte[] sign() {
            try {
                return this.s.sign();
            }
            catch (SignatureException ex) {
                throw new JwsException(JwsException.Error.SIGNATURE_FAILURE, (Throwable)ex);
            }
        }
    }
}

