/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.spi.bearer.token.provider;

import com.liferay.oauth2.provider.rest.internal.spi.bearer.token.provider.configuration.DefaultBearerTokenProviderConfiguration;
import com.liferay.oauth2.provider.rest.spi.bearer.token.provider.BearerTokenProvider;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.io.BigEndianCodec;
import com.liferay.portal.kernel.security.SecureRandomUtil;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@Component(configurationPid={"com.liferay.oauth2.provider.rest.internal.spi.bearer.token.provider.configuration.DefaultBearerTokenProviderConfiguration"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true, property={"name=default", "token.format=opaque"}, service={BearerTokenProvider.class})
public class DefaultBearerTokenProvider
implements BearerTokenProvider {
    private DefaultBearerTokenProviderConfiguration _defaultBearerTokenProviderConfiguration;

    public boolean isValid(BearerTokenProvider.AccessToken accessToken) {
        return this.isValid(accessToken.getExpiresIn(), accessToken.getIssuedAt());
    }

    public boolean isValid(BearerTokenProvider.RefreshToken refreshToken) {
        return this.isValid(refreshToken.getExpiresIn(), refreshToken.getIssuedAt());
    }

    public void onBeforeCreate(BearerTokenProvider.AccessToken accessToken) {
        String tokenKey = this.generateTokenKey(this._defaultBearerTokenProviderConfiguration.accessTokenKeyByteSize());
        accessToken.setTokenKey(tokenKey);
        accessToken.setExpiresIn((long)this._defaultBearerTokenProviderConfiguration.accessTokenExpiresIn());
    }

    public void onBeforeCreate(BearerTokenProvider.RefreshToken refreshToken) {
        String tokenKey = this.generateTokenKey(this._defaultBearerTokenProviderConfiguration.refreshTokenKeyByteSize());
        refreshToken.setTokenKey(tokenKey);
        refreshToken.setExpiresIn((long)this._defaultBearerTokenProviderConfiguration.refreshTokenExpiresIn());
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._defaultBearerTokenProviderConfiguration = (DefaultBearerTokenProviderConfiguration)ConfigurableUtil.createConfigurable(DefaultBearerTokenProviderConfiguration.class, properties);
    }

    protected String generateTokenKey(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Token key size is less than 0");
        }
        int count = (int)Math.ceil((double)size / 8.0);
        byte[] buffer = new byte[count * 8];
        for (int i = 0; i < count; ++i) {
            BigEndianCodec.putLong((byte[])buffer, (int)(i * 8), (long)SecureRandomUtil.nextLong());
        }
        StringBundler sb = new StringBundler(size);
        for (int i = 0; i < size; ++i) {
            sb.append(Integer.toHexString(0xFF & buffer[i]));
        }
        return sb.toString();
    }

    protected boolean isValid(long expiresIn, long issuedAt) {
        long expiresInMillis = expiresIn * 1000L;
        if (expiresInMillis < 0L) {
            return false;
        }
        long issuedAtMillis = issuedAt * 1000L;
        if (issuedAtMillis > System.currentTimeMillis()) {
            return false;
        }
        return issuedAtMillis + expiresInMillis >= System.currentTimeMillis();
    }
}

