/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.service.access.policy;

import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.security.service.access.policy.model.SAPEntry;
import com.liferay.portal.security.service.access.policy.service.SAPEntryLocalService;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={})
public class OAuth2RESTSAPEntryActivator {
    private static final String[][] _SAP_ENTRY_OBJECT_ARRAYS = new String[][]{{"AUTHORIZED_OAUTH2_SAP", "*"}};
    private static final Log _log = LogFactoryUtil.getLog(OAuth2RESTSAPEntryActivator.class);
    @Reference
    private SAPEntryLocalService _sapEntryLocalService;
    private ServiceRegistration<PortalInstanceLifecycleListener> _serviceRegistration;
    @Reference
    private UserLocalService _userLocalService;

    public void addSAPEntries(long companyId) throws PortalException {
        for (String[] sapEntryObjectArray : _SAP_ENTRY_OBJECT_ARRAYS) {
            String name = sapEntryObjectArray[0];
            SAPEntry sapEntry = this._sapEntryLocalService.fetchSAPEntry(companyId, name);
            if (sapEntry != null) continue;
            String allowedServiceSignatures = sapEntryObjectArray[1];
            ResourceBundleLoader resourceBundleLoader = ResourceBundleLoaderUtil.getResourceBundleLoaderByBundleSymbolicName((String)"com.liferay.oauth2.provider.rest");
            Map map = ResourceBundleUtil.getLocalizationMap((ResourceBundleLoader)resourceBundleLoader, (String)name);
            this._sapEntryLocalService.addSAPEntry(this._userLocalService.getDefaultUserId(companyId), allowedServiceSignatures, false, true, name, map, new ServiceContext());
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        boolean createSapEntriesOnStartup = MapUtil.getBoolean(properties, (String)"oauth2.create.oauth2.sap.entries.on.startup", (boolean)true);
        if (!createSapEntriesOnStartup) {
            return;
        }
        this._serviceRegistration = bundleContext.registerService(PortalInstanceLifecycleListener.class, (Object)new PolicyPortalInstanceLifecycleListener(), null);
    }

    @Deactivate
    protected void deactivate() {
        if (this._serviceRegistration != null) {
            this._serviceRegistration.unregister();
        }
    }

    private class PolicyPortalInstanceLifecycleListener
    extends BasePortalInstanceLifecycleListener {
        private PolicyPortalInstanceLifecycleListener() {
        }

        public void portalInstanceRegistered(Company company) throws Exception {
            try {
                OAuth2RESTSAPEntryActivator.this.addSAPEntries(company.getCompanyId());
            }
            catch (PortalException portalException) {
                _log.error((Object)("Unable to add service access policy entry for company " + company.getCompanyId()), (Throwable)portalException);
            }
        }
    }
}

