/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.security.auth.verifier;

import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.model.OAuth2Authorization;
import com.liferay.oauth2.provider.rest.spi.bearer.token.provider.BearerTokenProvider;
import com.liferay.oauth2.provider.rest.spi.bearer.token.provider.BearerTokenProviderAccessor;
import com.liferay.oauth2.provider.scope.liferay.ScopeContext;
import com.liferay.oauth2.provider.service.OAuth2ApplicationLocalService;
import com.liferay.oauth2.provider.service.OAuth2ApplicationScopeAliasesLocalService;
import com.liferay.oauth2.provider.service.OAuth2AuthorizationLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.AccessControlContext;
import com.liferay.portal.kernel.security.auth.AuthException;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifier;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifierResult;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, property={"auth.verifier.OAuth2RESTAuthVerifier.urls.includes=#N/A#"}, service={AuthVerifier.class})
public class OAuth2RESTAuthVerifier
implements AuthVerifier {
    private static final String _TOKEN_KEY = "Bearer";
    private static final Log _log = LogFactoryUtil.getLog(OAuth2RESTAuthVerifier.class);
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile BearerTokenProviderAccessor _bearerTokenProviderAccessor;
    @Reference
    private OAuth2ApplicationLocalService _oAuth2ApplicationLocalService;
    @Reference
    private OAuth2ApplicationScopeAliasesLocalService _oAuth2ApplicationScopeAliasesLocalService;
    @Reference
    private OAuth2AuthorizationLocalService _oAuth2AuthorizationLocalService;
    @Reference
    private ScopeContext _scopeContext;

    public String getAuthType() {
        return "OAuth2";
    }

    public AuthVerifierResult verify(AccessControlContext accessControlContext, Properties properties) throws AuthException {
        AuthVerifierResult authVerifierResult = new AuthVerifierResult();
        try {
            BearerTokenProvider.AccessToken accessToken = this.getAccessToken(accessControlContext);
            if (accessToken == null) {
                return authVerifierResult;
            }
            OAuth2Application oAuth2Application = accessToken.getOAuth2Application();
            long companyId = oAuth2Application.getCompanyId();
            if (companyId != CompanyThreadLocal.getCompanyId()) {
                return authVerifierResult;
            }
            BearerTokenProvider bearerTokenProvider = this._bearerTokenProviderAccessor.getBearerTokenProvider(oAuth2Application.getCompanyId(), oAuth2Application.getClientId());
            if (bearerTokenProvider == null) {
                return authVerifierResult;
            }
            if (!bearerTokenProvider.isValid(accessToken)) {
                return authVerifierResult;
            }
            this._scopeContext.setAccessToken(accessToken.getTokenKey());
            Map settings = authVerifierResult.getSettings();
            settings.put(BearerTokenProvider.AccessToken.class.getName(), accessToken);
            authVerifierResult.setState(AuthVerifierResult.State.SUCCESS);
            authVerifierResult.setUserId(accessToken.getUserId());
            return authVerifierResult;
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to verify OAuth2 access token", (Throwable)exception);
            }
            return authVerifierResult;
        }
    }

    protected BearerTokenProvider.AccessToken getAccessToken(AccessControlContext accessControlContext) throws PortalException {
        HttpServletRequest httpServletRequest = accessControlContext.getRequest();
        String authorization = httpServletRequest.getHeader("Authorization");
        if (Validator.isBlank((String)authorization)) {
            return null;
        }
        String[] authorizationParts = authorization.split("\\s");
        String scheme = authorizationParts[0];
        if (!StringUtil.equalsIgnoreCase((String)scheme, (String)_TOKEN_KEY)) {
            return null;
        }
        String token = authorizationParts[1];
        if (Validator.isBlank((String)token)) {
            return null;
        }
        OAuth2Authorization oAuth2Authorization = this._oAuth2AuthorizationLocalService.fetchOAuth2AuthorizationByAccessTokenContent(token);
        if (oAuth2Authorization == null) {
            return null;
        }
        String accessTokenContent = oAuth2Authorization.getAccessTokenContent();
        if ("EXPIRED_TOKEN".equals(accessTokenContent)) {
            return null;
        }
        OAuth2Application oAuth2Application = this._oAuth2ApplicationLocalService.getOAuth2Application(oAuth2Authorization.getOAuth2ApplicationId());
        Date createDate = oAuth2Authorization.getAccessTokenCreateDate();
        Date expirationDate = oAuth2Authorization.getAccessTokenExpirationDate();
        long expiresIn = (expirationDate.getTime() - createDate.getTime()) / 1000L;
        long issuedAt = createDate.getTime() / 1000L;
        List scopeAliasesList = Collections.emptyList();
        long oAuth2ApplicationScopeAliasesId = oAuth2Authorization.getOAuth2ApplicationScopeAliasesId();
        if (oAuth2ApplicationScopeAliasesId > 0L) {
            scopeAliasesList = this._oAuth2ApplicationScopeAliasesLocalService.getScopeAliasesList(oAuth2ApplicationScopeAliasesId);
        }
        return new BearerTokenProvider.AccessToken(oAuth2Application, new ArrayList(), "", expiresIn, new HashMap(), "", "", issuedAt, "", "", new HashMap(), "", "", scopeAliasesList, accessTokenContent, _TOKEN_KEY, oAuth2Authorization.getUserId(), oAuth2Authorization.getUserName());
    }
}

