/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.endpoint.liferay;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.grants.owner.ResourceOwnerLoginHandler;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ResourceOwnerLoginHandler.class})
public class LiferayResourceOwnerLoginHandler
implements ResourceOwnerLoginHandler {
    private static final Log _log = LogFactoryUtil.getLog(LiferayResourceOwnerLoginHandler.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public UserSubject createSubject(Client client, String login, String password) {
        try {
            User user = this.authenticateUser(login, password);
            if (user == null) {
                return null;
            }
            UserSubject userSubject = new UserSubject(user.getLogin(), String.valueOf(user.getUserId()));
            Map<String, String> properties = userSubject.getProperties();
            properties.put("company.id", String.valueOf(user.getCompanyId()));
            return userSubject;
        }
        catch (PortalException portalException) {
            _log.error((Object)portalException, (Throwable)portalException);
            return null;
        }
    }

    protected User authenticateUser(String login, String password) {
        int authResult = -1;
        Company company = this._companyLocalService.fetchCompany(CompanyThreadLocal.getCompanyId().longValue());
        String authType = company.getAuthType();
        HashMap resultsMap = new HashMap();
        try {
            if (authType.equals("emailAddress")) {
                authResult = this._userLocalService.authenticateByEmailAddress(company.getCompanyId(), login, password, Collections.emptyMap(), Collections.emptyMap(), resultsMap);
            } else if (authType.equals("screenName")) {
                authResult = this._userLocalService.authenticateByScreenName(company.getCompanyId(), login, password, Collections.emptyMap(), Collections.emptyMap(), resultsMap);
            } else if (authType.equals("userId")) {
                authResult = this._userLocalService.authenticateByUserId(company.getCompanyId(), GetterUtil.getLong((String)login), password, Collections.emptyMap(), Collections.emptyMap(), resultsMap);
            }
        }
        catch (PortalException portalException) {
            _log.error((Object)portalException, (Throwable)portalException);
            return null;
        }
        if (authResult == -1) {
            return null;
        }
        long userId = MapUtil.getLong(resultsMap, (String)"userId", (long)-1L);
        if (userId == -1L) {
            return null;
        }
        return this._userLocalService.fetchUser(userId);
    }
}

