/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.endpoint.liferay;

import com.liferay.oauth2.provider.configuration.OAuth2ProviderConfiguration;
import com.liferay.oauth2.provider.constants.GrantType;
import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.model.OAuth2ApplicationScopeAliases;
import com.liferay.oauth2.provider.model.OAuth2Authorization;
import com.liferay.oauth2.provider.rest.internal.endpoint.authorize.configuration.OAuth2AuthorizationFlowConfiguration;
import com.liferay.oauth2.provider.rest.internal.endpoint.liferay.ServerAuthorizationCodeGrantProvider;
import com.liferay.oauth2.provider.rest.spi.bearer.token.provider.BearerTokenProvider;
import com.liferay.oauth2.provider.rest.spi.bearer.token.provider.BearerTokenProviderAccessor;
import com.liferay.oauth2.provider.scope.liferay.LiferayOAuth2Scope;
import com.liferay.oauth2.provider.scope.liferay.ScopeLocator;
import com.liferay.oauth2.provider.service.OAuth2ApplicationLocalService;
import com.liferay.oauth2.provider.service.OAuth2ApplicationScopeAliasesLocalService;
import com.liferay.oauth2.provider.service.OAuth2AuthorizationLocalService;
import com.liferay.oauth2.provider.service.OAuth2ScopeGrantLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenRegistration;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.grants.code.AbstractAuthorizationCodeDataProvider;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeRegistration;
import org.apache.cxf.rs.security.oauth2.grants.code.ServerAuthorizationCodeGrant;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.tokens.bearer.BearerAccessToken;
import org.apache.cxf.rs.security.oauth2.tokens.refresh.RefreshToken;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(configurationPid={"com.liferay.oauth2.provider.configuration.OAuth2ProviderConfiguration", "com.liferay.oauth2.provider.rest.internal.endpoint.authorize.configuration.OAuth2AuthorizationFlowConfiguration"}, service={LiferayOAuthDataProvider.class})
public class LiferayOAuthDataProvider
extends AbstractAuthorizationCodeDataProvider {
    private static final Log _log = LogFactoryUtil.getLog(LiferayOAuthDataProvider.class);
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile BearerTokenProviderAccessor _bearerTokenProviderAccessor;
    @Reference
    private OAuth2ApplicationLocalService _oAuth2ApplicationLocalService;
    @Reference
    private OAuth2ApplicationScopeAliasesLocalService _oAuth2ApplicationScopeAliasesLocalService;
    private OAuth2AuthorizationFlowConfiguration _oAuth2AuthorizationFlowConfiguration;
    @Reference
    private OAuth2AuthorizationLocalService _oAuth2AuthorizationLocalService;
    private OAuth2ProviderConfiguration _oAuth2ProviderConfiguration;
    @Reference
    private OAuth2ScopeGrantLocalService _oAuth2ScopeGrantLocalService;
    @Reference
    private ScopeLocator _scopeLocator;
    @Reference
    private ServerAuthorizationCodeGrantProvider _serverAuthorizationCodeGrantProvider;
    @Reference
    private UserLocalService _userLocalService;

    public LiferayOAuthDataProvider() {
        this.setInvisibleToClientScopes(Collections.singletonList("refreshToken"));
    }

    @Override
    public List<OAuthPermission> convertScopeToPermissions(Client client, List<String> requestedScopes) {
        ArrayList<OAuthPermission> oAuth2Permissions = new ArrayList<OAuthPermission>();
        List<String> invisibleToClientScopes = this.getInvisibleToClientScopes();
        for (String requestedScope : requestedScopes) {
            OAuthPermission oAuthPermission = new OAuthPermission(requestedScope);
            if (invisibleToClientScopes.contains(oAuthPermission.getPermission())) {
                oAuthPermission.setInvisibleToClient(true);
            }
            oAuth2Permissions.add(oAuthPermission);
        }
        return oAuth2Permissions;
    }

    @Override
    public ServerAccessToken createAccessToken(AccessTokenRegistration accessTokenRegistration) throws OAuthServiceException {
        ArrayList<String> approvedScope = new ArrayList<String>(accessTokenRegistration.getRequestedScope());
        if (approvedScope.isEmpty()) {
            Client client = accessTokenRegistration.getClient();
            approvedScope.addAll(client.getRegisteredScopes());
        }
        accessTokenRegistration.setApprovedScope(approvedScope);
        if (!"client_credentials".equals(accessTokenRegistration.getGrantType())) {
            approvedScope.add("refreshToken");
        }
        return super.createAccessToken(accessTokenRegistration);
    }

    @Override
    public ServerAuthorizationCodeGrant createCodeGrant(AuthorizationCodeRegistration authorizationCodeRegistration) throws OAuthServiceException {
        ServerAuthorizationCodeGrant serverAuthorizationCodeGrant = super.createCodeGrant(authorizationCodeRegistration);
        serverAuthorizationCodeGrant.setRequestedScopes(authorizationCodeRegistration.getRequestedScope());
        this._serverAuthorizationCodeGrantProvider.putServerAuthorizationCodeGrant(serverAuthorizationCodeGrant);
        return serverAuthorizationCodeGrant;
    }

    @Override
    public void doRevokeAccessToken(ServerAccessToken accessToken) {
        OAuth2Authorization oAuth2Authorization = this._oAuth2AuthorizationLocalService.fetchOAuth2AuthorizationByAccessTokenContent(accessToken.getTokenKey());
        if (oAuth2Authorization == null) {
            return;
        }
        oAuth2Authorization.setAccessTokenContent("EXPIRED_TOKEN");
        this._oAuth2AuthorizationLocalService.updateOAuth2Authorization(oAuth2Authorization);
    }

    @Override
    public void doRevokeRefreshToken(RefreshToken refreshToken) {
        OAuth2Authorization oAuth2Authorization = this._oAuth2AuthorizationLocalService.fetchOAuth2AuthorizationByRefreshTokenContent(refreshToken.getTokenKey());
        if (oAuth2Authorization == null) {
            return;
        }
        oAuth2Authorization.setRefreshTokenContent("EXPIRED_TOKEN");
        this._oAuth2AuthorizationLocalService.updateOAuth2Authorization(oAuth2Authorization);
    }

    public BearerTokenProvider.AccessToken fromCXFAccessToken(ServerAccessToken serverAccessToken) {
        OAuth2Application oAuth2Application = this.resolveOAuth2Application(serverAccessToken.getClient());
        UserSubject userSubject = serverAccessToken.getSubject();
        return new BearerTokenProvider.AccessToken(oAuth2Application, serverAccessToken.getAudiences(), serverAccessToken.getClientCodeVerifier(), serverAccessToken.getExpiresIn(), serverAccessToken.getExtraProperties(), serverAccessToken.getGrantCode(), serverAccessToken.getGrantType(), serverAccessToken.getIssuedAt(), serverAccessToken.getIssuer(), serverAccessToken.getNonce(), serverAccessToken.getParameters(), serverAccessToken.getRefreshToken(), serverAccessToken.getResponseType(), OAuthUtils.convertPermissionsToScopeList(serverAccessToken.getScopes()), serverAccessToken.getTokenKey(), serverAccessToken.getTokenType(), GetterUtil.getLong((String)userSubject.getId()), userSubject.getLogin());
    }

    public BearerTokenProvider.RefreshToken fromCXFRefreshToken(RefreshToken refreshToken) {
        OAuth2Application oAuth2Application = this.resolveOAuth2Application(refreshToken.getClient());
        UserSubject userSubject = refreshToken.getSubject();
        return new BearerTokenProvider.RefreshToken(oAuth2Application, refreshToken.getAudiences(), refreshToken.getClientCodeVerifier(), refreshToken.getExpiresIn(), refreshToken.getGrantType(), refreshToken.getIssuedAt(), OAuthUtils.convertPermissionsToScopeList(refreshToken.getScopes()), refreshToken.getTokenKey(), refreshToken.getTokenType(), GetterUtil.getLong((String)userSubject.getId()), userSubject.getLogin());
    }

    @Override
    public ServerAccessToken getAccessToken(String accessToken) throws OAuthServiceException {
        if (Validator.isBlank((String)accessToken)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Remote client ", this._getRemoteIP(), " tried to use empty OAuth 2 access token"}));
            }
            return null;
        }
        OAuth2Authorization oAuth2Authorization = this._oAuth2AuthorizationLocalService.fetchOAuth2AuthorizationByAccessTokenContent(accessToken);
        if (oAuth2Authorization == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Remote client ", this._getRemoteIP(), " used unknown OAuth 2 token. Repeating report may be ", "a sign of a brute-force attack."}));
            }
            return null;
        }
        if ("EXPIRED_TOKEN".equals(oAuth2Authorization.getAccessTokenContent())) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Remote client ", this._getRemoteIP(), " tried to use expired or revoked OAuth 2 token for ", "Liferay OAuth 2 application ", oAuth2Authorization.getOAuth2ApplicationId(), " and user ", oAuth2Authorization.getUserId()}));
            }
            return null;
        }
        try {
            return this.populateAccessToken(oAuth2Authorization);
        }
        catch (PortalException portalException) {
            _log.error((Object)"Unable to populate access token", (Throwable)portalException);
            throw new OAuthServiceException(portalException);
        }
    }

    @Override
    public List<ServerAccessToken> getAccessTokens(Client client, UserSubject subject) throws OAuthServiceException {
        throw new UnsupportedOperationException();
    }

    public BearerTokenProvider getBearerTokenProvider(long companyId, String clientId) {
        return this._bearerTokenProviderAccessor.getBearerTokenProvider(companyId, clientId);
    }

    @Override
    public List<Client> getClients(UserSubject resourceOwner) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ServerAuthorizationCodeGrant> getCodeGrants(Client client, UserSubject subject) throws OAuthServiceException {
        return this._serverAuthorizationCodeGrantProvider.getServerAuthorizationCodeGrants(client, subject);
    }

    @Override
    public RefreshToken getRefreshToken(String refreshTokenKey) {
        if (Validator.isBlank((String)refreshTokenKey)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Remote client ", this._getRemoteIP(), " tried to use empty OAuth 2 refresh token"}));
            }
            return null;
        }
        try {
            OAuth2Authorization oAuth2Authorization = this._oAuth2AuthorizationLocalService.fetchOAuth2AuthorizationByRefreshTokenContent(refreshTokenKey);
            if (oAuth2Authorization == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"Remote client ", this._getRemoteIP(), " used unknown OAuth 2 refresh token. Repeating ", "report may be a sign of a brute force attack."}));
                }
                return null;
            }
            if ("EXPIRED_TOKEN".equals(oAuth2Authorization.getRefreshTokenContent())) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Remote client ", this._getRemoteIP(), " tried to use expired or revoked OAuth 2 refresh ", "token for Liferay OAuth 2 application ", oAuth2Authorization.getOAuth2ApplicationId(), " and user ", oAuth2Authorization.getUserId()}));
                }
                return null;
            }
            OAuth2Application oAuth2Application = this._oAuth2ApplicationLocalService.getOAuth2Application(oAuth2Authorization.getOAuth2ApplicationId());
            long expires = this.toCXFTime(oAuth2Authorization.getRefreshTokenExpirationDate());
            long issuedAt = this.toCXFTime(oAuth2Authorization.getRefreshTokenCreateDate());
            long lifetime = expires - issuedAt;
            RefreshToken refreshToken = new RefreshToken(this.populateClient(oAuth2Application), refreshTokenKey, lifetime, issuedAt);
            refreshToken.setSubject(this.populateUserSubject(oAuth2Authorization.getCompanyId(), oAuth2Authorization.getUserId(), oAuth2Authorization.getUserName()));
            List<String> accessTokens = Collections.singletonList(oAuth2Authorization.getAccessTokenContent());
            refreshToken.setAccessTokens(accessTokens);
            refreshToken.setScopes(this.convertScopeToPermissions(refreshToken.getClient(), this._oAuth2ApplicationScopeAliasesLocalService.getScopeAliasesList(oAuth2Authorization.getOAuth2ApplicationScopeAliasesId())));
            Map<String, String> extraProperties = refreshToken.getExtraProperties();
            extraProperties.put("company.id", String.valueOf(oAuth2Authorization.getCompanyId()));
            return refreshToken;
        }
        catch (PortalException portalException) {
            throw new OAuthServiceException(portalException);
        }
    }

    @Override
    public List<RefreshToken> getRefreshTokens(Client client, UserSubject subject) throws OAuthServiceException {
        return null;
    }

    public ServerAuthorizationCodeGrant getServerAuthorizationCodeGrant(String code) {
        if (code == null) {
            return null;
        }
        return this._serverAuthorizationCodeGrantProvider.getServerAuthorizationCodeGrant(code);
    }

    @Override
    public ServerAccessToken refreshAccessToken(Client client, String refreshTokenKey, List<String> restrictedScopes) throws OAuthServiceException {
        RefreshToken oldRefreshToken = this.getRefreshToken(refreshTokenKey);
        if (oldRefreshToken == null) {
            throw new OAuthServiceException("access_denied");
        }
        if (OAuthUtils.isExpired(oldRefreshToken.getIssuedAt(), oldRefreshToken.getExpiresIn())) {
            this.doRevokeRefreshToken(oldRefreshToken);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Remote client ", this._getRemoteIP(), " tried to use an expired OAuth 2 refresh token for ", "OAuth 2 client ID ", client.getClientId()}));
            }
            throw new OAuthServiceException("access_denied");
        }
        OAuth2Application oAuth2Application = this.resolveOAuth2Application(client);
        BearerTokenProvider bearerTokenProvider = this.getBearerTokenProvider(oAuth2Application.getCompanyId(), oAuth2Application.getClientId());
        if (!bearerTokenProvider.isValid(this.fromCXFRefreshToken(oldRefreshToken))) {
            this.doRevokeRefreshToken(oldRefreshToken);
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Remote client ", this._getRemoteIP(), " tried to use an invalid OAuth 2 token for OAuth 2 ", "client ID ", client.getClientId()}));
            }
            throw new OAuthServiceException("access_denied");
        }
        OAuth2Authorization oAuth2Authorization = this._oAuth2AuthorizationLocalService.fetchOAuth2AuthorizationByRefreshTokenContent(refreshTokenKey);
        if (oAuth2Authorization == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Remote client ", this._getRemoteIP(), " used unknown OAuth 2 refresh token for OAuth 2 ", "client ID ", client.getClientId(), ". Repeating report may be a sign of a brute force ", "attack."}));
            }
            throw new OAuthServiceException("access_denied");
        }
        ServerAccessToken accessToken = this.doRefreshAccessToken(client, oldRefreshToken, Collections.emptyList());
        accessToken.setRefreshToken(oldRefreshToken.getTokenKey());
        RefreshToken newRefreshToken = this.doCreateNewRefreshToken(accessToken);
        if (this._oAuth2ProviderConfiguration.recycleRefreshToken()) {
            newRefreshToken.setTokenKey(oldRefreshToken.getTokenKey());
        }
        List<String> accessTokens = newRefreshToken.getAccessTokens();
        accessTokens.add(accessToken.getTokenKey());
        try {
            LiferayOAuthDataProvider._invokeTransactionally(() -> {
                this.saveAccessToken(accessToken);
                this.saveRefreshToken(newRefreshToken);
            });
        }
        catch (Throwable throwable) {
            throw new OAuthServiceException(throwable);
        }
        accessToken.setRefreshToken(newRefreshToken.getTokenKey());
        return accessToken;
    }

    @Override
    public ServerAuthorizationCodeGrant removeCodeGrant(String code) throws OAuthServiceException {
        if (code == null) {
            return null;
        }
        return this._serverAuthorizationCodeGrantProvider.removeServerAuthorizationCodeGrant(code);
    }

    public OAuth2Application resolveOAuth2Application(Client client) {
        Map<String, String> properties = client.getProperties();
        long companyId = GetterUtil.getLong((String)properties.get("company.id"));
        OAuth2Application oAuth2Application = this._oAuth2ApplicationLocalService.fetchOAuth2Application(companyId, client.getClientId());
        if (oAuth2Application == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Remote client ", this._getRemoteIP(), " tried to use a nonexistent OAuth 2 client ID ", client.getClientId()}));
            }
            return null;
        }
        return oAuth2Application;
    }

    @Override
    public void setClient(Client client) {
        throw new UnsupportedOperationException();
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._oAuth2AuthorizationFlowConfiguration = (OAuth2AuthorizationFlowConfiguration)ConfigurableUtil.createConfigurable(OAuth2AuthorizationFlowConfiguration.class, properties);
        this._oAuth2ProviderConfiguration = (OAuth2ProviderConfiguration)ConfigurableUtil.createConfigurable(OAuth2ProviderConfiguration.class, properties);
        this.setGrantLifetime(this._oAuth2AuthorizationFlowConfiguration.authorizationCodeGrantTTL());
    }

    @Override
    protected ServerAccessToken doCreateAccessToken(AccessTokenRegistration accessTokenRegistration) {
        ServerAccessToken serverAccessToken = super.doCreateAccessToken(accessTokenRegistration);
        BearerTokenProvider.AccessToken accessToken = this.fromCXFAccessToken(serverAccessToken);
        OAuth2Application oAuth2Application = accessToken.getOAuth2Application();
        BearerTokenProvider bearerTokenProvider = this.getBearerTokenProvider(oAuth2Application.getCompanyId(), oAuth2Application.getClientId());
        bearerTokenProvider.onBeforeCreate(accessToken);
        serverAccessToken.setAudiences(accessToken.getAudiences());
        serverAccessToken.setClientCodeVerifier(accessToken.getClientCodeVerifier());
        serverAccessToken.setExpiresIn(accessToken.getExpiresIn());
        serverAccessToken.setExtraProperties(accessToken.getExtraProperties());
        serverAccessToken.setGrantCode(accessToken.getGrantCode());
        serverAccessToken.setGrantType(accessToken.getGrantType());
        serverAccessToken.setIssuedAt(accessToken.getIssuedAt());
        serverAccessToken.setIssuer(accessToken.getIssuer());
        serverAccessToken.setNonce(accessToken.getNonce());
        serverAccessToken.setParameters(accessToken.getParameters());
        serverAccessToken.setRefreshToken(accessToken.getRefreshToken());
        serverAccessToken.setResponseType(accessToken.getResponseType());
        serverAccessToken.setScopes(this.convertScopeToPermissions(serverAccessToken.getClient(), accessToken.getScopes()));
        serverAccessToken.setTokenKey(accessToken.getTokenKey());
        serverAccessToken.setTokenType(accessToken.getTokenType());
        UserSubject userSubject = serverAccessToken.getSubject();
        userSubject.setId(String.valueOf(accessToken.getUserId()));
        userSubject.setLogin(accessToken.getUserName());
        return serverAccessToken;
    }

    @Override
    protected RefreshToken doCreateNewRefreshToken(ServerAccessToken serverAccessToken) {
        RefreshToken cxfRefreshToken = super.doCreateNewRefreshToken(serverAccessToken);
        BearerTokenProvider.RefreshToken refreshToken = this.fromCXFRefreshToken(cxfRefreshToken);
        OAuth2Application oAuth2Application = refreshToken.getOAuth2Application();
        BearerTokenProvider bearerTokenProvider = this.getBearerTokenProvider(oAuth2Application.getCompanyId(), oAuth2Application.getClientId());
        bearerTokenProvider.onBeforeCreate(refreshToken);
        cxfRefreshToken.setAudiences(refreshToken.getAudiences());
        cxfRefreshToken.setClientCodeVerifier(refreshToken.getClientCodeVerifier());
        cxfRefreshToken.setExpiresIn(refreshToken.getExpiresIn());
        cxfRefreshToken.setGrantType(refreshToken.getGrantType());
        cxfRefreshToken.setIssuedAt(refreshToken.getIssuedAt());
        cxfRefreshToken.setScopes(this.convertScopeToPermissions(serverAccessToken.getClient(), refreshToken.getScopes()));
        cxfRefreshToken.setTokenKey(refreshToken.getTokenKey());
        cxfRefreshToken.setTokenType(refreshToken.getTokenType());
        UserSubject userSubject = cxfRefreshToken.getSubject();
        userSubject.setId(String.valueOf(refreshToken.getUserId()));
        userSubject.setLogin(refreshToken.getUserName());
        return cxfRefreshToken;
    }

    @Override
    protected Client doGetClient(String clientId) {
        OAuth2Application oAuth2Application = this._oAuth2ApplicationLocalService.fetchOAuth2Application(CompanyThreadLocal.getCompanyId().longValue(), clientId);
        if (oAuth2Application == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Remote client ", this._getRemoteIP(), " tried to use a nonexistent OAuth 2 client ID ", clientId}));
            }
            return null;
        }
        MessageContext messageContext = this.getMessageContext();
        messageContext.put((Object)"client_id", (Object)clientId);
        return this.populateClient(oAuth2Application);
    }

    @Override
    protected ServerAccessToken doRefreshAccessToken(Client client, RefreshToken oldRefreshToken, List<String> restrictedScopes) {
        ServerAccessToken serverAccessToken = super.doRefreshAccessToken(client, oldRefreshToken, restrictedScopes);
        BearerTokenProvider.AccessToken accessToken = this.fromCXFAccessToken(serverAccessToken);
        OAuth2Application oAuth2Application = accessToken.getOAuth2Application();
        BearerTokenProvider bearerTokenProvider = this.getBearerTokenProvider(oAuth2Application.getCompanyId(), oAuth2Application.getClientId());
        bearerTokenProvider.onBeforeCreate(accessToken);
        serverAccessToken.setAudiences(accessToken.getAudiences());
        serverAccessToken.setClientCodeVerifier(accessToken.getClientCodeVerifier());
        serverAccessToken.setExpiresIn(accessToken.getExpiresIn());
        serverAccessToken.setExtraProperties(accessToken.getExtraProperties());
        serverAccessToken.setGrantCode(accessToken.getGrantCode());
        serverAccessToken.setGrantType(accessToken.getGrantType());
        serverAccessToken.setIssuedAt(accessToken.getIssuedAt());
        serverAccessToken.setIssuer(accessToken.getIssuer());
        serverAccessToken.setNonce(accessToken.getNonce());
        serverAccessToken.setParameters(accessToken.getParameters());
        serverAccessToken.setRefreshToken(accessToken.getRefreshToken());
        serverAccessToken.setResponseType(accessToken.getResponseType());
        serverAccessToken.setScopes(this.convertScopeToPermissions(serverAccessToken.getClient(), accessToken.getScopes()));
        serverAccessToken.setTokenKey(accessToken.getTokenKey());
        serverAccessToken.setTokenType(accessToken.getTokenType());
        UserSubject userSubject = serverAccessToken.getSubject();
        userSubject.setId(String.valueOf(accessToken.getUserId()));
        userSubject.setLogin(accessToken.getUserName());
        return serverAccessToken;
    }

    @Override
    protected void doRemoveClient(Client c) {
        throw new UnsupportedOperationException();
    }

    protected Date fromCXFTime(long issuedAt) {
        return new Date(issuedAt * 1000L);
    }

    protected ServerAccessToken populateAccessToken(OAuth2Authorization oAuth2Authorization) throws PortalException {
        OAuth2Application oAuth2Application = this._oAuth2ApplicationLocalService.fetchOAuth2Application(oAuth2Authorization.getOAuth2ApplicationId());
        if (oAuth2Application == null) {
            throw new SystemException("No application found for authorization " + oAuth2Authorization);
        }
        Client client = this.getClient(oAuth2Application.getClientId());
        long expires = this.toCXFTime(oAuth2Authorization.getAccessTokenExpirationDate());
        long issuedAt = this.toCXFTime(oAuth2Authorization.getAccessTokenCreateDate());
        long lifetime = expires - issuedAt;
        BearerAccessToken serverAccessToken = new BearerAccessToken(client, oAuth2Authorization.getAccessTokenContent(), lifetime, issuedAt);
        serverAccessToken.setSubject(this.populateUserSubject(oAuth2Authorization.getCompanyId(), oAuth2Authorization.getUserId(), oAuth2Authorization.getUserName()));
        List<OAuthPermission> oAuth2Permissions = this.convertScopeToPermissions(client, this._oAuth2ApplicationScopeAliasesLocalService.getScopeAliasesList(oAuth2Authorization.getOAuth2ApplicationScopeAliasesId()));
        serverAccessToken.setScopes(oAuth2Permissions);
        Map<String, String> extraProperties = serverAccessToken.getExtraProperties();
        extraProperties.put("company.id", String.valueOf(oAuth2Authorization.getCompanyId()));
        return serverAccessToken;
    }

    protected Client populateClient(OAuth2Application oAuth2Application) {
        String clientSecret = oAuth2Application.getClientSecret();
        if (Validator.isBlank((String)clientSecret)) {
            clientSecret = null;
        }
        Client client = new Client(oAuth2Application.getClientId(), clientSecret, !Validator.isBlank((String)clientSecret), oAuth2Application.getName(), oAuth2Application.getHomePageURL());
        List<String> clientGrantTypes = client.getAllowedGrantTypes();
        for (GrantType allowedGrantType : oAuth2Application.getAllowedGrantTypesList()) {
            if (this._oAuth2ProviderConfiguration.allowAuthorizationCodeGrant() && allowedGrantType == GrantType.AUTHORIZATION_CODE) {
                clientGrantTypes.add("authorization_code");
                continue;
            }
            if (this._oAuth2ProviderConfiguration.allowAuthorizationCodePKCEGrant() && allowedGrantType == GrantType.AUTHORIZATION_CODE_PKCE) {
                clientGrantTypes.add("authorization_code");
                clientGrantTypes.add("authorization_code_pkce");
                continue;
            }
            if (this._oAuth2ProviderConfiguration.allowClientCredentialsGrant() && allowedGrantType == GrantType.CLIENT_CREDENTIALS) {
                clientGrantTypes.add("client_credentials");
                continue;
            }
            if (this._oAuth2ProviderConfiguration.allowResourceOwnerPasswordCredentialsGrant() && allowedGrantType == GrantType.RESOURCE_OWNER_PASSWORD) {
                clientGrantTypes.add("password");
                continue;
            }
            if (this._oAuth2ProviderConfiguration.allowRefreshTokenGrant() && allowedGrantType == GrantType.REFRESH_TOKEN) {
                clientGrantTypes.add("refresh_token");
                continue;
            }
            if (!_log.isDebugEnabled()) continue;
            _log.debug((Object)("Unknown or disabled grant type " + allowedGrantType));
        }
        if (clientGrantTypes.isEmpty()) {
            clientGrantTypes.add("");
        }
        client.setApplicationDescription(oAuth2Application.getDescription());
        if (oAuth2Application.getOAuth2ApplicationScopeAliasesId() > 0L) {
            client.setRegisteredScopes(this._oAuth2ApplicationScopeAliasesLocalService.getScopeAliasesList(oAuth2Application.getOAuth2ApplicationScopeAliasesId()));
        }
        client.setRedirectUris(oAuth2Application.getRedirectURIsList());
        client.setSubject(this.populateUserSubject(oAuth2Application.getCompanyId(), oAuth2Application.getClientCredentialUserId(), oAuth2Application.getClientCredentialUserName()));
        Map<String, String> properties = client.getProperties();
        properties.put("company.id", String.valueOf(oAuth2Application.getCompanyId()));
        properties.put("features", oAuth2Application.getFeatures());
        for (String feature : oAuth2Application.getFeaturesList()) {
            properties.put("feature." + feature, feature);
        }
        return client;
    }

    protected UserSubject populateUserSubject(long companyId, long userId, String username) {
        UserSubject userSubject = new UserSubject(username, String.valueOf(userId));
        Map<String, String> properties = userSubject.getProperties();
        properties.put("company.id", String.valueOf(companyId));
        return userSubject;
    }

    @Override
    protected void saveAccessToken(ServerAccessToken serverAccessToken) {
        try {
            LiferayOAuthDataProvider._invokeTransactionally(() -> this._transactionalSaveServerAccessToken(serverAccessToken));
        }
        catch (Throwable throwable) {
            throw new OAuthServiceException(throwable);
        }
    }

    @Override
    protected void saveRefreshToken(RefreshToken refreshToken) {
        List<String> accessTokens = refreshToken.getAccessTokens();
        if (ListUtil.isEmpty(accessTokens)) {
            throw new OAuthServiceException("Unable to find granted token");
        }
        Iterator<String> iterator = accessTokens.iterator();
        String accessTokenContent = iterator.next();
        OAuth2Authorization oAuth2Authorization = this._oAuth2AuthorizationLocalService.fetchOAuth2AuthorizationByAccessTokenContent(accessTokenContent);
        oAuth2Authorization.setRefreshTokenContent(refreshToken.getTokenKey());
        Date createDate = this.fromCXFTime(refreshToken.getIssuedAt());
        oAuth2Authorization.setRefreshTokenCreateDate(createDate);
        Date expirationDate = this.fromCXFTime(refreshToken.getIssuedAt() + refreshToken.getExpiresIn());
        oAuth2Authorization.setRefreshTokenExpirationDate(expirationDate);
        this._oAuth2AuthorizationLocalService.updateOAuth2Authorization(oAuth2Authorization);
    }

    protected long toCXFTime(Date dateCreated) {
        return dateCreated.getTime() / 1000L;
    }

    private static void _invokeTransactionally(Runnable runnable) throws Throwable {
        TransactionInvokerUtil.invoke((TransactionConfig)TransactionConfig.Factory.create((Propagation)Propagation.REQUIRED, (Class[])new Class[]{Exception.class}, (Class[])new Class[0]), () -> {
            runnable.run();
            return null;
        });
    }

    private Collection<LiferayOAuth2Scope> _getLiferayOAuth2Scopes(long oAuth2ApplicationScopeAliasesId, List<String> scopeAliases) {
        Collection oAuth2ScopeGrants = this._oAuth2ScopeGrantLocalService.getOAuth2ScopeGrants(oAuth2ApplicationScopeAliasesId, -1, -1, null);
        Stream stream = oAuth2ScopeGrants.stream();
        OAuth2ApplicationScopeAliases oAuth2ApplicationScopeAliases = this._oAuth2ApplicationScopeAliasesLocalService.fetchOAuth2ApplicationScopeAliases(oAuth2ApplicationScopeAliasesId);
        Collection liferayOAuth2Scopes = new ArrayList();
        if (oAuth2ApplicationScopeAliases != null) {
            liferayOAuth2Scopes = this._scopeLocator.getLiferayOAuth2Scopes(oAuth2ApplicationScopeAliases.getCompanyId());
        }
        return stream.filter(oAuth2ScopeGrant -> !Collections.disjoint(oAuth2ScopeGrant.getScopeAliasesList(), scopeAliases)).map(oAuth2ScopeGrant -> this._scopeLocator.getLiferayOAuth2Scope(oAuth2ScopeGrant.getCompanyId(), oAuth2ScopeGrant.getApplicationName(), oAuth2ScopeGrant.getScope())).filter(Objects::nonNull).filter(liferayOAuth2Scopes::contains).collect(Collectors.toList());
    }

    private String _getRemoteIP() {
        MessageContext messageContext = this.getMessageContext();
        HttpServletRequest httpServletRequest = messageContext.getHttpServletRequest();
        return httpServletRequest.getRemoteAddr() + " - " + httpServletRequest.getRemoteHost();
    }

    private void _transactionalSaveServerAccessToken(ServerAccessToken serverAccessToken) {
        Date createDate = this.fromCXFTime(serverAccessToken.getIssuedAt());
        Date expirationDate = this.fromCXFTime(serverAccessToken.getIssuedAt() + serverAccessToken.getExpiresIn());
        if (serverAccessToken.getRefreshToken() != null) {
            OAuth2Authorization oAuth2Authorization = this._oAuth2AuthorizationLocalService.fetchOAuth2AuthorizationByRefreshTokenContent(serverAccessToken.getRefreshToken());
            oAuth2Authorization.setAccessTokenContent(serverAccessToken.getTokenKey());
            oAuth2Authorization.setAccessTokenCreateDate(createDate);
            oAuth2Authorization.setAccessTokenExpirationDate(expirationDate);
            this._oAuth2AuthorizationLocalService.updateOAuth2Authorization(oAuth2Authorization);
            return;
        }
        Client client = serverAccessToken.getClient();
        OAuth2Application oAuth2Application = this.resolveOAuth2Application(client);
        long userId = 0L;
        String userName = "";
        UserSubject userSubject = serverAccessToken.getSubject();
        if (userSubject != null) {
            try {
                userId = GetterUtil.getLong((String)userSubject.getId());
                User user = this._userLocalService.getUser(userId);
                userName = user.getFullName();
            }
            catch (Exception exception) {
                _log.error((Object)("Unable to load user " + userSubject.getId()), (Throwable)exception);
                throw new RuntimeException(exception);
            }
        }
        Map<String, String> properties = client.getProperties();
        String remoteAddr = properties.get("client.remote.addr");
        String remoteHost = properties.get("client.remote.host");
        OAuth2Authorization oAuth2Authorization = this._oAuth2AuthorizationLocalService.addOAuth2Authorization(oAuth2Application.getCompanyId(), userId, userName, oAuth2Application.getOAuth2ApplicationId(), oAuth2Application.getOAuth2ApplicationScopeAliasesId(), serverAccessToken.getTokenKey(), createDate, expirationDate, remoteHost, remoteAddr, null, null, null);
        List<String> scopeAliasesList = OAuthUtils.convertPermissionsToScopeList(serverAccessToken.getScopes());
        try {
            this._oAuth2ScopeGrantLocalService.grantLiferayOAuth2Scopes(oAuth2Authorization.getOAuth2AuthorizationId(), this._getLiferayOAuth2Scopes(oAuth2Authorization.getOAuth2ApplicationScopeAliasesId(), scopeAliasesList));
        }
        catch (PortalException portalException) {
            _log.error((Object)("Unable to find authorization " + oAuth2Authorization));
            throw new OAuthServiceException("Unable to grant scope for token", (Throwable)portalException);
        }
    }
}

