/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.endpoint.access.token;

import com.liferay.oauth2.provider.rest.internal.endpoint.access.token.LiferayAccessTokenService;
import com.liferay.oauth2.provider.rest.internal.endpoint.liferay.LiferayOAuthDataProvider;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.cxf.rs.security.oauth2.provider.AccessTokenGrantHandler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.FieldOption;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, property={"block.unsecure.requests=true", "can.support.public.clients=true", "enabled=true"}, service={})
public class LiferayAccessTokenServiceRegistrator {
    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, fieldOption=FieldOption.UPDATE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile List<AccessTokenGrantHandler> _accessTokenGrantHandlers = new CopyOnWriteArrayList<AccessTokenGrantHandler>();
    @Reference
    private LiferayOAuthDataProvider _liferayOAuthDataProvider;
    private volatile ServiceRegistration<Object> _serviceRegistration;

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        if (!MapUtil.getBoolean(properties, (String)"enabled", (boolean)true)) {
            return;
        }
        LiferayAccessTokenService liferayAccessTokenService = new LiferayAccessTokenService();
        liferayAccessTokenService.setBlockUnsecureRequests(MapUtil.getBoolean(properties, (String)"block.unsecure.requests", (boolean)true));
        liferayAccessTokenService.setCanSupportPublicClients(MapUtil.getBoolean(properties, (String)"allow.public.clients", (boolean)true));
        liferayAccessTokenService.setDataProvider(this._liferayOAuthDataProvider);
        liferayAccessTokenService.setGrantHandlers(this._accessTokenGrantHandlers);
        HashMapDictionary liferayAccessTokenServiceProperties = new HashMapDictionary();
        liferayAccessTokenServiceProperties.put("osgi.jaxrs.application.select", "(osgi.jaxrs.name=Liferay.OAuth2.Application)");
        liferayAccessTokenServiceProperties.put("osgi.jaxrs.name", "Liferay.Access.Token.Service.");
        liferayAccessTokenServiceProperties.put("osgi.jaxrs.resource", true);
        this._serviceRegistration = bundleContext.registerService(Object.class, (Object)liferayAccessTokenService, (Dictionary)liferayAccessTokenServiceProperties);
    }

    @Deactivate
    protected void deactivate() {
        if (this._serviceRegistration != null) {
            this._serviceRegistration.unregister();
            this._serviceRegistration = null;
        }
    }
}

