/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.endpoint.access.token;

import com.liferay.portal.kernel.util.InetAddressUtil;
import com.liferay.portal.remote.cors.annotation.CORS;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.services.AccessTokenService;

@Path(value="/token")
public class LiferayAccessTokenService
extends AccessTokenService {
    @Override
    @Consumes(value={"application/x-www-form-urlencoded"})
    @CORS(allowMethods={"POST"})
    @POST
    @Produces(value={"application/json"})
    public Response handleTokenRequest(MultivaluedMap<String, String> params) {
        return super.handleTokenRequest(params);
    }

    @Override
    protected Client authenticateClientIfNeeded(MultivaluedMap<String, String> params) {
        String clientSecret;
        String clientId = (String)params.getFirst((Object)"client_id");
        if (clientId != null && clientId.isEmpty()) {
            this.reportInvalidClient();
        }
        if ((clientSecret = (String)params.getFirst((Object)"client_secret")) != null && clientSecret.isEmpty()) {
            params.remove((Object)"client_secret");
        }
        Client client = super.authenticateClientIfNeeded(params);
        Map<String, String> properties = client.getProperties();
        MessageContext messageContext = this.getMessageContext();
        HttpServletRequest httpServletRequest = messageContext.getHttpServletRequest();
        String remoteAddr = httpServletRequest.getRemoteAddr();
        String remoteHost = httpServletRequest.getRemoteHost();
        try {
            InetAddress inetAddress = InetAddressUtil.getInetAddressByName((String)remoteAddr);
            remoteHost = inetAddress.getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        properties.put("client.remote.addr", remoteAddr);
        properties.put("client.remote.host", remoteHost);
        return client;
    }

    @Override
    protected void injectContextIntoOAuthProviders() {
    }
}

