/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.filters;

import java.time.Instant;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.rs.security.jose.jwt.JoseJwtConsumer;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenValidation;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.AccessTokenValidator;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.utils.JwtTokenUtils;

public class JwtAccessTokenValidator
extends JoseJwtConsumer
implements AccessTokenValidator {
    private static final String USERNAME_PROP = "username";
    private Map<String, String> jwtAccessTokenClaimMap;

    @Override
    public List<String> getSupportedAuthorizationSchemes() {
        return Collections.singletonList("Bearer");
    }

    @Override
    public AccessTokenValidation validateAccessToken(MessageContext mc, String authScheme, String authSchemeData, MultivaluedMap<String, String> extraProps) throws OAuthServiceException {
        try {
            JwtToken token = super.getJwtToken(authSchemeData);
            return this.convertClaimsToValidation(token.getClaims());
        }
        catch (Exception ex) {
            throw new OAuthServiceException(ex);
        }
    }

    private AccessTokenValidation convertClaimsToValidation(JwtClaims claims) {
        Object certCnf;
        Map cnfClaim;
        String usernameClaimName;
        String username;
        Object scope;
        List<String> audiences;
        AccessTokenValidation atv = new AccessTokenValidation();
        atv.setInitialValidationSuccessful(true);
        String clientId = claims.getStringProperty("client_id");
        if (clientId != null) {
            atv.setClientId(clientId);
        }
        if (claims.getIssuedAt() != null) {
            atv.setTokenIssuedAt(claims.getIssuedAt());
        } else {
            Instant now = Instant.now();
            atv.setTokenIssuedAt(now.toEpochMilli());
        }
        if (claims.getExpiryTime() != null) {
            atv.setTokenLifetime(claims.getExpiryTime() - atv.getTokenIssuedAt());
        }
        if ((audiences = claims.getAudiences()) != null && !audiences.isEmpty()) {
            atv.setAudiences(claims.getAudiences());
        }
        if (claims.getIssuer() != null) {
            atv.setTokenIssuer(claims.getIssuer());
        }
        if ((scope = claims.getClaim("scope")) != null) {
            String[] scopes = scope instanceof String ? scope.toString().split(" ") : CastUtils.cast((List)((List)scope)).toArray(new String[0]);
            LinkedList<OAuthPermission> perms = new LinkedList<OAuthPermission>();
            for (String s : scopes) {
                if (StringUtils.isEmpty((String)s)) continue;
                perms.add(new OAuthPermission(s.trim()));
            }
            atv.setTokenScopes(perms);
        }
        if ((username = claims.getStringProperty(usernameClaimName = JwtTokenUtils.getClaimName(USERNAME_PROP, USERNAME_PROP, this.jwtAccessTokenClaimMap))) != null) {
            UserSubject userSubject = new UserSubject(username);
            if (claims.getSubject() != null) {
                userSubject.setId(claims.getSubject());
            }
            atv.setTokenSubject(userSubject);
        } else if (claims.getSubject() != null) {
            atv.setTokenSubject(new UserSubject(claims.getSubject()));
        }
        Map extraProperties = CastUtils.cast((Map)((Map)claims.getClaim("extra_properties")));
        if (extraProperties != null) {
            atv.getExtraProps().putAll(extraProperties);
        }
        if ((cnfClaim = CastUtils.cast((Map)((Map)claims.getClaim("cnf")))) != null && (certCnf = cnfClaim.get("x5t#S256")) != null) {
            atv.getExtraProps().put("x5t#S256", certCnf.toString());
        }
        return atv;
    }

    public void setJwtAccessTokenClaimMap(Map<String, String> jwtAccessTokenClaimMap) {
        this.jwtAccessTokenClaimMap = jwtAccessTokenClaimMap;
    }
}

