/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.client;

import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.json.basic.JsonMapObjectReaderWriter;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jws.JwsCompactConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsCompactProducer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.jose.jws.NoneJwsSignatureProvider;
import org.apache.cxf.rs.security.oauth2.client.ClientCodeStateManager;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

public class JoseClientCodeStateManager
implements ClientCodeStateManager {
    private JwsSignatureProvider sigProvider;
    private JweEncryptionProvider encryptionProvider;
    private JweDecryptionProvider decryptionProvider;
    private JwsSignatureVerifier signatureVerifier;
    private JsonMapObjectReaderWriter jsonp = new JsonMapObjectReaderWriter();
    private boolean generateNonce;
    private boolean storeInSession;

    @Override
    public MultivaluedMap<String, String> toRedirectState(MessageContext mc, MultivaluedMap<String, String> requestState) {
        JweEncryptionProvider theEncryptionProvider = this.getInitializedEncryptionProvider();
        JwsSignatureProvider theSigProvider = this.getInitializedSigProvider(theEncryptionProvider);
        if (theEncryptionProvider == null && theSigProvider == null) {
            throw new OAuthServiceException("The state can not be protected");
        }
        MetadataMap redirectMap = new MetadataMap();
        if (this.generateNonce && theSigProvider != null) {
            JwsCompactProducer nonceProducer = new JwsCompactProducer(OAuthUtils.generateRandomTokenKey());
            String nonceParam = nonceProducer.signWith(theSigProvider);
            requestState.putSingle((Object)"nonce", (Object)nonceParam);
            redirectMap.putSingle((Object)"nonce", (Object)nonceParam);
        }
        Map stateMap = CastUtils.cast(requestState);
        String json = this.jsonp.toJson(stateMap);
        String stateParam = null;
        if (theSigProvider != null) {
            JwsCompactProducer stateProducer = new JwsCompactProducer(json);
            stateParam = stateProducer.signWith(theSigProvider);
        }
        if (theEncryptionProvider != null) {
            stateParam = theEncryptionProvider.encrypt(StringUtils.toBytesUTF8(stateParam), null);
        }
        if (this.storeInSession) {
            String sessionStateAttribute = OAuthUtils.generateRandomTokenKey();
            OAuthUtils.setSessionToken(mc, stateParam, sessionStateAttribute, 0);
            stateParam = sessionStateAttribute;
        }
        redirectMap.putSingle((Object)"state", (Object)stateParam);
        return redirectMap;
    }

    @Override
    public MultivaluedMap<String, String> fromRedirectState(MessageContext mc, MultivaluedMap<String, String> redirectState) {
        JwsSignatureVerifier theSigVerifier;
        JwsCompactConsumer jws;
        JweDecryptionProvider jwe;
        String stateParam = (String)redirectState.getFirst((Object)"state");
        if (this.storeInSession) {
            stateParam = OAuthUtils.getSessionToken(mc, stateParam);
        }
        if ((jwe = this.getInitializedDecryptionProvider()) != null) {
            stateParam = jwe.decrypt(stateParam).getContentText();
        }
        if (!(jws = new JwsCompactConsumer(stateParam)).verifySignatureWith(theSigVerifier = this.getInitializedSigVerifier())) {
            throw new SecurityException();
        }
        String json = jws.getUnsignedEncodedSequence();
        Map map = CastUtils.cast((Map)this.jsonp.fromJson(json));
        return (MultivaluedMap)map;
    }

    public void setSignatureProvider(JwsSignatureProvider signatureProvider) {
        this.sigProvider = signatureProvider;
    }

    protected JwsSignatureProvider getInitializedSigProvider(JweEncryptionProvider theEncryptionProvider) {
        if (this.sigProvider != null) {
            return this.sigProvider;
        }
        JwsSignatureProvider theSigProvider = JwsUtils.loadSignatureProvider(false);
        if (theSigProvider == null && theEncryptionProvider != null) {
            theSigProvider = new NoneJwsSignatureProvider();
        }
        return theSigProvider;
    }

    public void setDecryptionProvider(JweDecryptionProvider decProvider) {
        this.decryptionProvider = decProvider;
    }

    protected JweDecryptionProvider getInitializedDecryptionProvider() {
        if (this.decryptionProvider != null) {
            return this.decryptionProvider;
        }
        return JweUtils.loadDecryptionProvider(false);
    }

    public void setSignatureVerifier(JwsSignatureVerifier signatureVerifier) {
        this.signatureVerifier = signatureVerifier;
    }

    protected JwsSignatureVerifier getInitializedSigVerifier() {
        if (this.signatureVerifier != null) {
            return this.signatureVerifier;
        }
        return JwsUtils.loadSignatureVerifier(false);
    }

    public void setEncryptionProvider(JweEncryptionProvider encProvider) {
        this.encryptionProvider = encProvider;
    }

    protected JweEncryptionProvider getInitializedEncryptionProvider() {
        if (this.encryptionProvider != null) {
            return this.encryptionProvider;
        }
        return JweUtils.loadEncryptionProvider(false);
    }

    public void setGenerateNonce(boolean generateNonce) {
        this.generateNonce = generateNonce;
    }

    public void setStoreInSession(boolean storeInSession) {
        this.storeInSession = storeInSession;
    }
}

