/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.security.KeyPair;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.rs.security.jose.jwa.ContentAlgorithm;
import org.apache.cxf.rs.security.jose.jwa.KeyAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AesGcmContentEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.DirectKeyEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweEncryption;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jwk.JwkUtils;
import org.apache.cxf.rt.security.crypto.CryptoUtils;

public class EcdhDirectKeyJweEncryption
extends JweEncryption {
    public EcdhDirectKeyJweEncryption(ECPublicKey peerPublicKey, String curve, ContentAlgorithm ctAlgo) {
        this(peerPublicKey, curve, null, null, ctAlgo);
    }

    public EcdhDirectKeyJweEncryption(ECPublicKey peerPublicKey, String curve, String apuString, String apvString, ContentAlgorithm ctAlgo) {
        super(new EcdhDirectKeyEncryptionAlgorithm(), new EcdhAesGcmContentEncryptionAlgorithm(peerPublicKey, curve, apuString, apvString, ctAlgo));
    }

    protected static class EcdhHelper {
        private ECPublicKey peerPublicKey;
        private String ecurve;
        private byte[] apuBytes;
        private byte[] apvBytes;
        private String ctAlgo;

        public EcdhHelper(ECPublicKey peerPublicKey, String curve, String apuString, String apvString, String ctAlgo) {
            this.ctAlgo = ctAlgo;
            this.peerPublicKey = peerPublicKey;
            this.ecurve = curve;
            this.apuBytes = this.toApuBytes(apuString);
            this.apvBytes = this.toBytes(apvString);
        }

        public byte[] getDerivedKey(JweHeaders headers) {
            KeyPair pair = CryptoUtils.generateECKeyPair(this.ecurve);
            ECPublicKey publicKey = (ECPublicKey)pair.getPublic();
            ECPrivateKey privateKey = (ECPrivateKey)pair.getPrivate();
            ContentAlgorithm jwtAlgo = ContentAlgorithm.valueOf(this.ctAlgo);
            headers.setHeader("apu", Base64UrlUtility.encode((byte[])this.apuBytes));
            headers.setHeader("apv", Base64UrlUtility.encode((byte[])this.apvBytes));
            headers.setJsonWebKey("epk", JwkUtils.fromECPublicKey(publicKey, this.ecurve));
            return JweUtils.getECDHKey(privateKey, this.peerPublicKey, this.apuBytes, this.apvBytes, jwtAlgo.getJwaName(), jwtAlgo.getKeySizeBits());
        }

        private byte[] toApuBytes(String apuString) {
            if (apuString != null) {
                return this.toBytes(apuString);
            }
            return CryptoUtils.generateSecureRandomBytes(64);
        }

        private byte[] toBytes(String str) {
            return str == null ? null : StringUtils.toBytesUTF8((String)str);
        }
    }

    protected static class EcdhAesGcmContentEncryptionAlgorithm
    extends AesGcmContentEncryptionAlgorithm {
        private EcdhHelper helper;

        public EcdhAesGcmContentEncryptionAlgorithm(ECPublicKey peerPublicKey, String curve, String apuString, String apvString, ContentAlgorithm ctAlgo) {
            super(ctAlgo);
            this.helper = new EcdhHelper(peerPublicKey, curve, apuString, apvString, ctAlgo.getJwaName());
        }

        @Override
        public byte[] getContentEncryptionKey(JweHeaders headers) {
            return this.helper.getDerivedKey(headers);
        }
    }

    protected static class EcdhDirectKeyEncryptionAlgorithm
    extends DirectKeyEncryptionAlgorithm {
        protected EcdhDirectKeyEncryptionAlgorithm() {
        }

        @Override
        protected void checkKeyEncryptionAlgorithm(JweHeaders headers) {
            headers.setKeyEncryptionAlgorithm(KeyAlgorithm.ECDH_ES_DIRECT);
        }
    }
}

