/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.rs.security.jose.common.JoseUtils;
import org.apache.cxf.rs.security.jose.jaxrs.JoseJaxrsUtils;
import org.apache.cxf.rs.security.jose.jwe.JweCompactConsumer;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionOutput;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;

public class AbstractJweDecryptingFilter {
    private Set<String> protectedHttpHeaders;
    private boolean validateHttpHeaders;
    private JweDecryptionProvider decryption;
    private String defaultMediaType;
    private boolean checkEmptyStream;

    protected JweDecryptionOutput decrypt(InputStream is) throws IOException {
        JweCompactConsumer jwe = new JweCompactConsumer(new String(IOUtils.readBytesFromStream((InputStream)is), StandardCharsets.UTF_8));
        JweDecryptionProvider theDecryptor = this.getInitializedDecryptionProvider(jwe.getJweHeaders());
        JweDecryptionOutput out = new JweDecryptionOutput(jwe.getJweHeaders(), jwe.getDecryptedContent(theDecryptor));
        JoseUtils.traceHeaders(out.getHeaders());
        this.validateHeaders(out.getHeaders());
        return out;
    }

    protected void validateHeaders(JweHeaders headers) {
    }

    public void setDecryptionProvider(JweDecryptionProvider decryptor) {
        this.decryption = decryptor;
    }

    protected JweDecryptionProvider getInitializedDecryptionProvider(JweHeaders headers) {
        if (this.decryption != null) {
            return this.decryption;
        }
        return JweUtils.loadDecryptionProvider(headers, true);
    }

    public String getDefaultMediaType() {
        return this.defaultMediaType;
    }

    public void setDefaultMediaType(String defaultMediaType) {
        this.defaultMediaType = defaultMediaType;
    }

    public void setValidateHttpHeaders(boolean validateHttpHeaders) {
        this.validateHttpHeaders = validateHttpHeaders;
    }

    public boolean isValidateHttpHeaders() {
        return this.validateHttpHeaders;
    }

    protected void validateHttpHeadersIfNeeded(MultivaluedMap<String, String> httpHeaders, JweHeaders jweHeaders) {
        JoseJaxrsUtils.validateHttpHeaders(httpHeaders, jweHeaders, this.protectedHttpHeaders);
    }

    public void setProtectedHttpHeaders(Set<String> protectedHttpHeaders) {
        this.protectedHttpHeaders = protectedHttpHeaders;
    }

    public boolean isCheckEmptyStream() {
        return this.checkEmptyStream;
    }

    public void setCheckEmptyStream(boolean checkEmptyStream) {
        this.checkEmptyStream = checkEmptyStream;
    }
}

