/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.jaxrs.feature;

import com.liferay.oauth2.provider.scope.RequiresScope;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;

public class RequiresScopeAnnotationFinder {
    public static Collection<String> find(Class<?> clazz) {
        HashSet<String> scopes = new HashSet<String>();
        RequiresScopeAnnotationFinder._find(new HashSet(), scopes, true, clazz);
        return scopes;
    }

    private static void _find(Set<Class<?>> classes, Set<String> scopes, boolean recurse, Class<?> clazz) {
        RequiresScope requiresScope = clazz.getDeclaredAnnotation(RequiresScope.class);
        if (requiresScope != null) {
            Collections.addAll(scopes, requiresScope.value());
        }
        Stream<Method> stream = Arrays.stream(clazz.getMethods());
        List methods = stream.filter(RequiresScopeAnnotationFinder::_isAnnotatedMethod).collect(Collectors.toList());
        for (Method method : methods) {
            RequiresScopeAnnotationFinder._find(classes, scopes, recurse, method);
        }
        classes.remove(clazz);
    }

    private static void _find(Set<Class<?>> visited, Set<String> scopes, boolean recurse, Method method) {
        RequiresScope requiresScope = method.getDeclaredAnnotation(RequiresScope.class);
        if (requiresScope != null) {
            Collections.addAll(scopes, requiresScope.value());
        }
        if (RequiresScopeAnnotationFinder._isSubresourceLocator(method) && recurse) {
            RequiresScopeAnnotationFinder._find(visited, scopes, false, method.getReturnType());
        }
    }

    private static boolean _isAnnotatedMethod(Method method) {
        return method.getDeclaredAnnotation(Path.class) != null || RequiresScopeAnnotationFinder._isHttpMethod(method);
    }

    private static boolean _isHttpMethod(Method method) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = method.getAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (annotationType.getAnnotationsByType(HttpMethod.class) == null) continue;
            return true;
        }
        return false;
    }

    private static boolean _isSubresourceLocator(Method method) {
        return method.getDeclaredAnnotation(Path.class) != null || !RequiresScopeAnnotationFinder._isHttpMethod(method);
    }
}

