/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.jaxrs.feature;

import com.liferay.oauth2.provider.rest.internal.jaxrs.feature.CollectionScopeFinder;
import com.liferay.oauth2.provider.rest.spi.scope.checker.container.request.filter.BaseScopeCheckerContainerRequestFilter;
import com.liferay.oauth2.provider.scope.ScopeChecker;
import com.liferay.oauth2.provider.scope.spi.scope.finder.ScopeFinder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.core.Request;
import javax.ws.rs.ext.Provider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Priority(value=1992)
@Provider
@Component(property={"osgi.jaxrs.application.select=(|(!(oauth2.scopechecker.type=*))(oauth2.scopechecker.type=http.method))", "osgi.jaxrs.extension=true", "osgi.jaxrs.extension.select=(osgi.jaxrs.name=Liferay.OAuth2)", "osgi.jaxrs.name=Liferay.OAuth2.HTTP.method.request.checker"}, scope=ServiceScope.PROTOTYPE, service={Feature.class})
public class HttpMethodFeature
implements Feature {
    private BundleContext _bundleContext;
    @Reference
    private ScopeChecker _scopeChecker;
    private ServiceRegistration<ScopeFinder> _serviceRegistration;

    public boolean configure(FeatureContext context) {
        HashMap<Class<ContainerRequestFilter>, Integer> contracts = new HashMap<Class<ContainerRequestFilter>, Integer>();
        contracts.put(ContainerRequestFilter.class, 1992);
        context.register((Object)new HttpScopeCheckerContainerRequestFilter(), contracts);
        Configuration configuration = context.getConfiguration();
        this._serviceRegistration = this._bundleContext.registerService(ScopeFinder.class, (Object)new CollectionScopeFinder(Arrays.asList("DELETE", "GET", "HEAD", "OPTIONS", "POST", "PUT")), new Hashtable((Map)configuration.getProperty("osgi.jaxrs.application.serviceProperties")));
        return true;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    @Deactivate
    protected void deactivate() {
        if (this._serviceRegistration != null) {
            this._serviceRegistration.unregister();
        }
    }

    private class HttpScopeCheckerContainerRequestFilter
    extends BaseScopeCheckerContainerRequestFilter {
        private HttpScopeCheckerContainerRequestFilter() {
        }

        public boolean isContainerRequestContextAllowed(ContainerRequestContext containerRequestContext) {
            Request request = containerRequestContext.getRequest();
            return HttpMethodFeature.this._scopeChecker.checkScope(request.getMethod());
        }
    }
}

