/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.jaxrs.feature;

import com.liferay.oauth2.provider.rest.internal.jaxrs.feature.CollectionScopeFinder;
import com.liferay.oauth2.provider.rest.internal.jaxrs.feature.configuration.ConfigurableScopeCheckerFeatureConfiguration;
import com.liferay.oauth2.provider.rest.spi.scope.checker.container.request.filter.BaseScopeCheckerContainerRequestFilter;
import com.liferay.oauth2.provider.scope.ScopeChecker;
import com.liferay.oauth2.provider.scope.spi.scope.finder.ScopeFinder;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Priority(value=1992)
@Provider
@Component(configurationPid={"com.liferay.oauth2.provider.rest.internal.jaxrs.feature.configuration.ConfigurableScopeCheckerFeatureConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"osgi.jaxrs.extension=true", "osgi.jaxrs.extension.select=(osgi.jaxrs.name=Liferay.OAuth2)", "osgi.jaxrs.name=Liferay.OAuth2.HTTP.configurable.request.checker"}, scope=ServiceScope.PROTOTYPE, service={Feature.class})
public class ConfigurableScopeCheckerFeature
implements Feature {
    private static final Log _log = LogFactoryUtil.getLog(ConfigurableScopeCheckerFeature.class);
    private boolean _allowUnmatched;
    private BundleContext _bundleContext;
    private final List<CheckPattern> _checkPatterns = new ArrayList<CheckPattern>();
    @Reference
    private ScopeChecker _scopeChecker;
    private ServiceRegistration<ScopeFinder> _serviceRegistration;

    @Activate
    public void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._bundleContext = bundleContext;
        ConfigurableScopeCheckerFeatureConfiguration configurableCheckerFeatureConfiguration = (ConfigurableScopeCheckerFeatureConfiguration)ConfigurableUtil.createConfigurable(ConfigurableScopeCheckerFeatureConfiguration.class, properties);
        this._allowUnmatched = configurableCheckerFeatureConfiguration.allowUnmatched();
        for (String pattern : configurableCheckerFeatureConfiguration.patterns()) {
            String[] split = pattern.split("::");
            if (split.length != 3) {
                _log.error((Object)("Invalid syntax " + pattern + " does not match 3 sequences of ::"));
                return;
            }
            String methodPatternString = split[0];
            String urlPatternString = split[1];
            String scopesString = split[2];
            String[] scopes = scopesString.split(",");
            try {
                this._checkPatterns.add(new CheckPattern(Pattern.compile(methodPatternString), Pattern.compile(urlPatternString), scopes));
            }
            catch (PatternSyntaxException pse) {
                _log.error((Object)("Invalid pattern " + pattern), (Throwable)pse);
                throw new IllegalArgumentException(pse);
            }
        }
    }

    public boolean configure(FeatureContext context) {
        if (this._checkPatterns.isEmpty()) {
            return false;
        }
        HashMap<Class<ContainerRequestFilter>, Integer> contracts = new HashMap<Class<ContainerRequestFilter>, Integer>();
        contracts.put(ContainerRequestFilter.class, 1992);
        context.register((Object)new ConfigurableContainerScopeCheckerContainerRequestFilter(), contracts);
        Configuration configuration = context.getConfiguration();
        Stream stream = this._checkPatterns.stream();
        this._serviceRegistration = this._bundleContext.registerService(ScopeFinder.class, (Object)new CollectionScopeFinder(stream.flatMap(c -> Arrays.stream(c.getScopes())).filter(Validator::isNotNull).collect(Collectors.toSet())), this.buildProperties(configuration));
        return true;
    }

    protected Dictionary<String, Object> buildProperties(Configuration configuration) {
        HashMapDictionary properties = new HashMapDictionary();
        properties.putAll((Map)configuration.getProperty("osgi.jaxrs.application.serviceProperties"));
        properties.put((Object)"service.ranking", (Object)Integer.MIN_VALUE);
        return properties;
    }

    @Deactivate
    protected void deactivate() {
        if (this._serviceRegistration != null) {
            this._serviceRegistration.unregister();
        }
    }

    private class ConfigurableContainerScopeCheckerContainerRequestFilter
    extends BaseScopeCheckerContainerRequestFilter {
        @Context
        private UriInfo _uriInfo;

        private ConfigurableContainerScopeCheckerContainerRequestFilter() {
        }

        public boolean isContainerRequestContextAllowed(ContainerRequestContext containerRequestContext) {
            boolean anyMatch = false;
            String path = "/" + this._uriInfo.getPath();
            Request request = containerRequestContext.getRequest();
            for (CheckPattern checkPattern : ConfigurableScopeCheckerFeature.this._checkPatterns) {
                if (!this.matches(checkPattern, path, request)) continue;
                anyMatch = true;
                Object[] scopes = checkPattern.getScopes();
                if (this.requiresNoScope((String[])scopes)) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Path  " + path + " was approved, does not require a scope"));
                    }
                    return true;
                }
                if (!ConfigurableScopeCheckerFeature.this._scopeChecker.checkAllScopes((String[])scopes)) continue;
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((String[])new String[]{"Path ", path, " was approved, token includes all scopes ", StringUtil.merge((Object[])scopes)}));
                }
                return true;
            }
            if (anyMatch) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((String[])new String[]{"Path ", path, " was not allowed because it does not have ", "required scopes"}));
                }
                return false;
            }
            if (ConfigurableScopeCheckerFeature.this._allowUnmatched) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((String[])new String[]{"Path ", path, " was approved, does not match any patterns"}));
                }
                return true;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Path ", path, " was not allowed because it does not match any ", "patterns"}));
            }
            return false;
        }

        protected boolean matches(CheckPattern checkPattern, String path, Request request) {
            Predicate<String> urlPatternPredicate = checkPattern.getUrlPatternPredicate();
            if (!urlPatternPredicate.test(path)) {
                return false;
            }
            Predicate<String> methodPatternPredicate = checkPattern.getMethodPatternPredicate();
            return methodPatternPredicate.test(request.getMethod());
        }

        protected boolean requiresNoScope(String[] scopes) {
            if (ArrayUtil.isEmpty((Object[])scopes)) {
                return true;
            }
            return scopes.length == 1 && Validator.isNull((String)scopes[0]);
        }
    }

    private static class CheckPattern {
        private final Predicate<String> _methodPatternPredicate;
        private final String[] _scopes;
        private final Predicate<String> _urlPatternPredicate;

        public CheckPattern(Pattern methodPattern, Pattern urlPattern, String[] scopes) {
            this._methodPatternPredicate = methodPattern.asPredicate();
            this._urlPatternPredicate = urlPattern.asPredicate();
            this._scopes = scopes;
        }

        public Predicate<String> getMethodPatternPredicate() {
            return this._methodPatternPredicate;
        }

        public String[] getScopes() {
            return this._scopes;
        }

        public Predicate<String> getUrlPatternPredicate() {
            return this._urlPatternPredicate;
        }
    }
}

