/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.endpoint.introspect;

import com.liferay.oauth2.provider.rest.internal.endpoint.introspect.TokenIntrospection;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.osgi.service.component.annotations.Component;

@Produces(value={"application/json"})
@Provider
@Component(property={"osgi.jaxrs.application.select=(osgi.jaxrs.name=Liferay.OAuth2.Application)", "osgi.jaxrs.extension=true", "osgi.jaxrs.name=TokenIntrospectionJSONProviderMessageBodyWriter"}, service={MessageBodyWriter.class})
public class TokenIntrospectionJSONProviderMessageBodyWriter
implements MessageBodyWriter<TokenIntrospection> {
    public long getSize(TokenIntrospection tokenIntrospection, Class<?> clazz, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> clazz, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return TokenIntrospection.class.isAssignableFrom(clazz);
    }

    public void writeTo(TokenIntrospection tokenIntrospection, Class<?> clazz, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream outputStream) throws IOException, WebApplicationException {
        if (!tokenIntrospection.isActive()) {
            StringBundler sb = new StringBundler(6);
            sb.append("{");
            this.append(sb, "active", false, false);
            sb.append("}");
            String string = sb.toString();
            outputStream.write(string.getBytes(StandardCharsets.UTF_8));
            outputStream.flush();
            return;
        }
        StringBundler sb = new StringBundler(72);
        sb.append("{");
        this.append(sb, "active", tokenIntrospection.isActive(), false);
        if (tokenIntrospection.getAud() != null) {
            ArrayList<String> audience = new ArrayList<String>(tokenIntrospection.getAud());
            audience.removeIf(String::isEmpty);
            if (!audience.isEmpty()) {
                StringBundler audienceSB;
                if (audience.size() == 1) {
                    audienceSB = new StringBundler(7);
                    Iterator iterator = audience.iterator();
                    this.append(audienceSB, "aud", (String)iterator.next());
                } else {
                    audienceSB = new StringBundler(5);
                    this.append(audienceSB, "aud", audience);
                }
                sb.append(audienceSB);
            }
        }
        this.append(sb, "client_id", tokenIntrospection.getClientId());
        this.append(sb, "exp", tokenIntrospection.getExp());
        this.append(sb, "iat", tokenIntrospection.getIat());
        this.append(sb, "iss", tokenIntrospection.getIss());
        this.append(sb, "jti", tokenIntrospection.getJti());
        this.append(sb, "nbf", tokenIntrospection.getNbf());
        this.append(sb, "scope", tokenIntrospection.getScope());
        this.append(sb, "sub", tokenIntrospection.getSub());
        this.append(sb, "token_type", tokenIntrospection.getTokenType());
        this.append(sb, "username", tokenIntrospection.getUsername());
        Map<String, String> extensions = tokenIntrospection.getExtensions();
        if (MapUtil.isNotEmpty(extensions)) {
            StringBundler extensionSB = new StringBundler(extensions.size() * 7);
            for (Map.Entry<String, String> extension : extensions.entrySet()) {
                this.append(extensionSB, extension.getKey(), extension.getValue());
            }
            sb.append(extensionSB);
        }
        sb.append("}");
        String result = sb.toString();
        outputStream.write(result.getBytes(StandardCharsets.UTF_8));
        outputStream.flush();
    }

    protected void append(StringBundler sb, String key, List<String> value) {
        StringBundler arraySB = new StringBundler(value.size() * 3 - 1 + 2);
        arraySB.append("[");
        for (int i = 0; i < value.size(); ++i) {
            if (i > 0) {
                arraySB.append(",");
            }
            this.appendValue(arraySB, value.get(i), true);
        }
        arraySB.append("]");
        sb.append(",");
        this.append(sb, key, arraySB.toString(), false);
    }

    protected void append(StringBundler sb, String key, Long value) {
        if (value == null) {
            return;
        }
        sb.append(",");
        this.append(sb, key, value, false);
    }

    protected void append(StringBundler sb, String key, Object value, boolean quote) {
        sb.append("\"");
        sb.append(key);
        sb.append("\":");
        this.appendValue(sb, value, quote);
    }

    protected void append(StringBundler sb, String key, String value) {
        if (value == null) {
            return;
        }
        sb.append(",");
        this.append(sb, key, value, true);
    }

    protected void appendValue(StringBundler sb, Object value, boolean quote) {
        if (quote) {
            sb.append("\"");
            String stringValue = value == null ? "null" : StringUtil.replace((String)value.toString(), (String[])new String[]{"\\", "\""}, (String[])new String[]{"\\\\", "\\\""});
            sb.append(stringValue);
            sb.append("\"");
        } else {
            sb.append(value);
        }
    }
}

