/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.endpoint.introspect;

import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.rest.internal.endpoint.introspect.TokenIntrospection;
import com.liferay.oauth2.provider.rest.internal.endpoint.liferay.LiferayOAuthDataProvider;
import com.liferay.oauth2.provider.rest.spi.bearer.token.provider.BearerTokenProvider;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.Consumes;
import javax.ws.rs.Encoded;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.services.AbstractTokenService;
import org.apache.cxf.rs.security.oauth2.tokens.refresh.RefreshToken;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

@Path(value="introspect")
public class LiferayTokenIntrospectionService
extends AbstractTokenService {
    private final LiferayOAuthDataProvider _liferayOAuthDataProvider;

    public LiferayTokenIntrospectionService(LiferayOAuthDataProvider liferayOAuthDataProvider, boolean canSupportPublicClients) {
        this._liferayOAuthDataProvider = liferayOAuthDataProvider;
        this.setCanSupportPublicClients(canSupportPublicClients);
        this.setDataProvider(liferayOAuthDataProvider);
    }

    @Consumes(value={"application/x-www-form-urlencoded"})
    @POST
    @Produces(value={"application/json"})
    public Response getTokenIntrospection(@Encoded MultivaluedMap<String, String> params) {
        Client client = this.authenticateClientIfNeeded(params);
        String tokenId = (String)params.getFirst((Object)"token");
        String tokenTypeHint = (String)params.getFirst((Object)"token_type_hint");
        if (tokenTypeHint == null) {
            ServerAccessToken serverAccessToken = this._liferayOAuthDataProvider.getAccessToken(tokenId);
            if (serverAccessToken != null) {
                return this.handleAccessToken(client, serverAccessToken);
            }
            RefreshToken refreshToken = this._liferayOAuthDataProvider.getRefreshToken(tokenId);
            if (refreshToken != null) {
                return this.handleRefreshToken(client, refreshToken);
            }
        } else if ("access_token".equals(tokenTypeHint)) {
            ServerAccessToken serverAccessToken = this._liferayOAuthDataProvider.getAccessToken(tokenId);
            if (serverAccessToken != null) {
                return this.handleAccessToken(client, serverAccessToken);
            }
        } else if ("refresh_token".equals(tokenTypeHint)) {
            RefreshToken refreshToken = this._liferayOAuthDataProvider.getRefreshToken(tokenId);
            if (refreshToken != null) {
                return this.handleRefreshToken(client, refreshToken);
            }
        } else {
            return this.createErrorResponseFromErrorCode("unsupported_token_type");
        }
        return Response.ok((Object)new TokenIntrospection(false)).build();
    }

    protected boolean clientsMatch(Client client1, Client client2) {
        String companyId2;
        if (!Objects.equals(client1.getClientId(), client2.getClientId())) {
            return false;
        }
        String companyId1 = MapUtil.getString(client1.getProperties(), (String)"company.id");
        return Objects.equals(companyId1, companyId2 = MapUtil.getString(client2.getProperties(), (String)"company.id"));
    }

    protected TokenIntrospection createTokenIntrospection(ServerAccessToken serverAccessToken) {
        UserSubject userSubject;
        String issuer;
        TokenIntrospection tokenIntrospection = new TokenIntrospection(true);
        List<String> audiences = serverAccessToken.getAudiences();
        if (ListUtil.isNotEmpty(audiences)) {
            tokenIntrospection.setAud(audiences);
        }
        Client client = serverAccessToken.getClient();
        tokenIntrospection.setClientId(client.getClientId());
        tokenIntrospection.setExp(serverAccessToken.getIssuedAt() + serverAccessToken.getExpiresIn());
        Map<String, String> extraProperties = serverAccessToken.getExtraProperties();
        if (extraProperties != null) {
            Map<String, String> extensions = tokenIntrospection.getExtensions();
            extensions.putAll(extraProperties);
        }
        if ((issuer = serverAccessToken.getIssuer()) != null) {
            tokenIntrospection.setIss(issuer);
        }
        tokenIntrospection.setIat(serverAccessToken.getIssuedAt());
        List<OAuthPermission> oAuthPermissions = serverAccessToken.getScopes();
        if (ListUtil.isNotEmpty(oAuthPermissions)) {
            tokenIntrospection.setScope(OAuthUtils.convertPermissionsToScope(oAuthPermissions));
        }
        if ((userSubject = serverAccessToken.getSubject()) != null) {
            tokenIntrospection.setUsername(userSubject.getLogin());
            tokenIntrospection.setSub(userSubject.getId());
        }
        tokenIntrospection.setTokenType(serverAccessToken.getTokenType());
        return tokenIntrospection;
    }

    protected Response handleAccessToken(Client client, ServerAccessToken serverAccessToken) {
        if (!this.verifyClient(client, serverAccessToken)) {
            return this.createErrorResponseFromErrorCode("unauthorized_client");
        }
        if (!this.verifyServerAccessToken(serverAccessToken)) {
            return Response.ok((Object)new TokenIntrospection(false)).build();
        }
        BearerTokenProvider.AccessToken bearerAccessToken = this._liferayOAuthDataProvider.fromCXFAccessToken(serverAccessToken);
        OAuth2Application oAuth2Application = bearerAccessToken.getOAuth2Application();
        BearerTokenProvider bearerTokenProvider = this._liferayOAuthDataProvider.getBearerTokenProvider(oAuth2Application.getCompanyId(), oAuth2Application.getClientId());
        if (!bearerTokenProvider.isValid(bearerAccessToken)) {
            return Response.ok((Object)new TokenIntrospection(false)).build();
        }
        return Response.ok((Object)this.createTokenIntrospection(serverAccessToken)).build();
    }

    protected Response handleRefreshToken(Client client, RefreshToken refreshToken) {
        if (!this.verifyClient(client, refreshToken)) {
            return this.createErrorResponseFromErrorCode("unauthorized_client");
        }
        if (!this.verifyServerAccessToken(refreshToken)) {
            return Response.ok((Object)new TokenIntrospection(false)).build();
        }
        BearerTokenProvider.RefreshToken bearerRefreshToken = this._liferayOAuthDataProvider.fromCXFRefreshToken(refreshToken);
        OAuth2Application oAuth2Application = bearerRefreshToken.getOAuth2Application();
        BearerTokenProvider bearerTokenProvider = this._liferayOAuthDataProvider.getBearerTokenProvider(oAuth2Application.getCompanyId(), oAuth2Application.getClientId());
        if (!bearerTokenProvider.isValid(bearerRefreshToken)) {
            return Response.ok((Object)new TokenIntrospection(false)).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)this.createTokenIntrospection(refreshToken)).build();
    }

    protected boolean verifyClient(Client client, ServerAccessToken serverAccessToken) {
        if (!this.clientsMatch(client, serverAccessToken.getClient())) {
            return false;
        }
        Map<String, String> properties = client.getProperties();
        return properties.containsKey("feature.token_introspection");
    }

    protected boolean verifyServerAccessToken(ServerAccessToken serverAccessToken) {
        return !OAuthUtils.isExpired(serverAccessToken.getIssuedAt(), serverAccessToken.getExpiresIn());
    }
}

