/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.endpoint.authorize;

import com.liferay.oauth2.provider.configuration.OAuth2ProviderConfiguration;
import com.liferay.oauth2.provider.rest.internal.endpoint.liferay.LiferayOAuthDataProvider;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import java.util.Dictionary;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.OAuthError;
import org.apache.cxf.rs.security.oauth2.common.OOBAuthorizationResponse;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.provider.SubjectCreator;
import org.apache.cxf.rs.security.oauth2.services.AuthorizationCodeGrantService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.oauth2.provider.configuration.OAuth2ProviderConfiguration"}, immediate=true, service={})
public class AuthorizationCodeGrantServiceRegistrator {
    private static final Log _log = LogFactoryUtil.getLog(AuthorizationCodeGrantServiceRegistrator.class);
    @Reference
    private LiferayOAuthDataProvider _liferayOAuthDataProvider;
    private ServiceRegistration<Object> _serviceRegistration;
    @Reference
    private SubjectCreator _subjectCreator;

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        OAuth2ProviderConfiguration oAuth2ProviderConfiguration = (OAuth2ProviderConfiguration)ConfigurableUtil.createConfigurable(OAuth2ProviderConfiguration.class, properties);
        if (!oAuth2ProviderConfiguration.allowAuthorizationCodeGrant() && !oAuth2ProviderConfiguration.allowAuthorizationCodePKCEGrant()) {
            return;
        }
        AuthorizationCodeGrantService authorizationCodeGrantService = new AuthorizationCodeGrantService(){

            @Override
            protected Response deliverOOBResponse(OOBAuthorizationResponse oobAuthorizationResponse) {
                _log.error((Object)("The parameter \"redirect_uri\" was not found in the request for client " + oobAuthorizationResponse.getClientId()));
                return Response.status((int)500).build();
            }

            @Override
            protected Client getClient(String clientId, MultivaluedMap<String, String> params) {
                block4: {
                    try {
                        Client client = this.getValidClient(clientId, params);
                        if (client != null) {
                            return client;
                        }
                    }
                    catch (OAuthServiceException oase) {
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)"Unable to validate remote client", (Throwable)oase);
                        }
                        if (oase.getError() == null) break block4;
                        this.reportInvalidRequestError(oase.getError(), null);
                    }
                }
                this.reportInvalidRequestError(new OAuthError("invalid_client"), null);
                return null;
            }
        };
        authorizationCodeGrantService.setCanSupportPublicClients(oAuth2ProviderConfiguration.allowAuthorizationCodePKCEGrant());
        authorizationCodeGrantService.setDataProvider(this._liferayOAuthDataProvider);
        authorizationCodeGrantService.setSubjectCreator(this._subjectCreator);
        HashMapDictionary authorizationCodeGrantProperties = new HashMapDictionary();
        authorizationCodeGrantProperties.put("osgi.jaxrs.application.select", "(osgi.jaxrs.name=Liferay.OAuth2.Application)");
        authorizationCodeGrantProperties.put("osgi.jaxrs.name", "Liferay.Authorization.Code.Grant.Service");
        authorizationCodeGrantProperties.put("osgi.jaxrs.resource", true);
        this._serviceRegistration = bundleContext.registerService(Object.class, (Object)authorizationCodeGrantService, (Dictionary)authorizationCodeGrantProperties);
    }

    @Deactivate
    protected void deactivate() {
        if (this._serviceRegistration != null) {
            this._serviceRegistration.unregister();
        }
    }
}

