/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.endpoint.authorize;

import com.liferay.oauth2.provider.rest.internal.endpoint.authorize.configuration.AuthorizeScreenConfiguration;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.servlet.ProtectedPrincipal;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.net.URI;
import java.security.Principal;
import javax.annotation.Priority;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.security.SecurityContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@PreMatching
@Priority(value=1000)
@Provider
@Component(property={"osgi.jaxrs.application.select=(osgi.jaxrs.name=Liferay.OAuth2.Application)", "osgi.jaxrs.extension=true", "osgi.jaxrs.name=AuthorizationCodeGrantServiceContainerRequestFilter"}, service={ContainerRequestFilter.class})
public class AuthorizationCodeGrantServiceContainerRequestFilter
implements ContainerRequestFilter {
    private static final Log _log = LogFactoryUtil.getLog(AuthorizationCodeGrantServiceContainerRequestFilter.class);
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private Http _http;
    @Context
    private HttpServletRequest _httpServletRequest;
    @Reference
    private Portal _portal;

    public void filter(ContainerRequestContext containerRequestContext) {
        UriInfo uriInfo = containerRequestContext.getUriInfo();
        if (!StringUtil.startsWith((String)uriInfo.getPath(), (String)"authorize")) {
            return;
        }
        try {
            final User user = this._portal.getUser(this._httpServletRequest);
            if (user != null && !user.isDefaultUser()) {
                containerRequestContext.setSecurityContext((javax.ws.rs.core.SecurityContext)new PortalCXFSecurityContext(){

                    public Principal getUserPrincipal() {
                        return new ProtectedPrincipal(String.valueOf(user.getUserId()));
                    }

                    public boolean isSecure() {
                        return AuthorizationCodeGrantServiceContainerRequestFilter.this._portal.isSecure(AuthorizationCodeGrantServiceContainerRequestFilter.this._httpServletRequest);
                    }
                });
                return;
            }
        }
        catch (Exception e) {
            _log.error((Object)"Unable to resolve authenticated user", (Throwable)e);
            containerRequestContext.abortWith(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build());
            return;
        }
        String loginURL = null;
        try {
            loginURL = this.getLoginURL();
        }
        catch (ConfigurationException ce) {
            _log.error((Object)"Unable to locate configuration", (Throwable)ce);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build());
        }
        URI requestURI = uriInfo.getRequestUri();
        loginURL = this._http.addParameter(loginURL, "redirect", requestURI.toASCIIString());
        containerRequestContext.abortWith(Response.status((Response.Status)Response.Status.FOUND).location(URI.create(loginURL)).build());
    }

    protected String getLoginURL() throws ConfigurationException {
        long companyId = this._portal.getCompanyId(this._httpServletRequest);
        AuthorizeScreenConfiguration authorizeScreenConfiguration = (AuthorizeScreenConfiguration)this._configurationProvider.getConfiguration(AuthorizeScreenConfiguration.class, (SettingsLocator)new CompanyServiceSettingsLocator(companyId, AuthorizeScreenConfiguration.class.getName()));
        String loginURL = authorizeScreenConfiguration.loginURL();
        if (Validator.isBlank((String)loginURL)) {
            StringBundler sb = new StringBundler(4);
            sb.append(this._portal.getPortalURL(this._httpServletRequest));
            sb.append(this._portal.getPathContext());
            sb.append(this._portal.getPathMain());
            sb.append("/portal/login");
            loginURL = sb.toString();
        } else if (!this._http.hasDomain(loginURL)) {
            String portalURL = this._portal.getPortalURL(this._httpServletRequest);
            loginURL = portalURL + loginURL;
        }
        return loginURL;
    }

    private static abstract class PortalCXFSecurityContext
    implements javax.ws.rs.core.SecurityContext,
    SecurityContext {
        private PortalCXFSecurityContext() {
        }

        public String getAuthenticationScheme() {
            return "session";
        }

        public boolean isUserInRole(String role) {
            return false;
        }
    }
}

