/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.endpoint.access.token;

import com.liferay.oauth2.provider.rest.internal.endpoint.access.token.LiferayAccessTokenService;
import com.liferay.oauth2.provider.rest.internal.endpoint.liferay.LiferayOAuthDataProvider;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import org.apache.cxf.rs.security.oauth2.provider.AccessTokenGrantHandler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, property={"block.unsecure.requests=true", "can.support.public.clients=true", "enabled=true"}, service={})
public class LiferayAccessTokenServiceRegistrator {
    private final List<AccessTokenGrantHandler> _accessTokenGrantHandlers = new ArrayList<AccessTokenGrantHandler>();
    private boolean _blockUnsecureRequests;
    private BundleContext _bundleContext;
    private boolean _canSupportPublicClients;
    private volatile boolean _enabled;
    @Reference
    private LiferayOAuthDataProvider _liferayOAuthDataProvider;
    private volatile ServiceRegistration<Object> _serviceRegistration;

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._blockUnsecureRequests = MapUtil.getBoolean(properties, (String)"block.unsecure.requests", (boolean)true);
        this._canSupportPublicClients = MapUtil.getBoolean(properties, (String)"allow.public.clients", (boolean)true);
        this._enabled = MapUtil.getBoolean(properties, (String)"enabled", (boolean)true);
        this._bundleContext = bundleContext;
        this._updateLiferayAccessTokenService(bundleContext);
    }

    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addAccessTokenGrantHandler(AccessTokenGrantHandler accessTokenGrantHandler) {
        this._accessTokenGrantHandlers.add(accessTokenGrantHandler);
        this._updateLiferayAccessTokenService(this._bundleContext);
    }

    @Deactivate
    protected void deactivate() {
        this._enabled = false;
        this.unregister();
    }

    protected void removeAccessTokenGrantHandler(AccessTokenGrantHandler accessTokenGrantHandler) {
        this._accessTokenGrantHandlers.remove(accessTokenGrantHandler);
        this._updateLiferayAccessTokenService(this._bundleContext);
    }

    protected void unregister() {
        if (this._serviceRegistration != null) {
            this._serviceRegistration.unregister();
            this._serviceRegistration = null;
        }
    }

    private void _updateLiferayAccessTokenService(BundleContext bundleContext) {
        if (!this._enabled || bundleContext == null) {
            return;
        }
        LiferayAccessTokenService liferayAccessTokenService = new LiferayAccessTokenService();
        liferayAccessTokenService.setBlockUnsecureRequests(this._blockUnsecureRequests);
        liferayAccessTokenService.setCanSupportPublicClients(this._canSupportPublicClients);
        liferayAccessTokenService.setDataProvider(this._liferayOAuthDataProvider);
        liferayAccessTokenService.setGrantHandlers(this._accessTokenGrantHandlers);
        HashMapDictionary liferayAccessTokenServiceProperties = new HashMapDictionary();
        liferayAccessTokenServiceProperties.put("osgi.jaxrs.application.select", "(osgi.jaxrs.name=Liferay.OAuth2.Application)");
        liferayAccessTokenServiceProperties.put("osgi.jaxrs.name", "Liferay.Access.Token.Service.");
        liferayAccessTokenServiceProperties.put("osgi.jaxrs.resource", true);
        this.unregister();
        this._serviceRegistration = bundleContext.registerService(Object.class, (Object)liferayAccessTokenService, (Dictionary)liferayAccessTokenServiceProperties);
    }
}

