/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.spi.bearer.token.provider;

import com.liferay.oauth2.provider.model.OAuth2Application;
import java.util.List;
import java.util.Map;

public interface BearerTokenProvider {
    public boolean isValid(AccessToken var1);

    default public boolean isValid(RefreshToken refreshToken) {
        return true;
    }

    default public void onBeforeCreate(AccessToken accessToken) {
    }

    default public void onBeforeCreate(RefreshToken refreshToken) {
    }

    public static class RefreshToken {
        private List<String> _audiences;
        private String _clientCodeVerifier;
        private long _expiresIn;
        private String _grantType;
        private long _issuedAt;
        private OAuth2Application _oAuth2Application;
        private List<String> _scopes;
        private String _tokenKey;
        private String _tokenType;
        private long _userId;
        private String _userName;

        public RefreshToken(OAuth2Application oAuth2Application, List<String> audiences, String clientCodeVerifier, long expiresIn, String grantType, long issuedAt, List<String> scopes, String tokenKey, String tokenType, long userId, String userName) {
            this._oAuth2Application = oAuth2Application;
            this._audiences = audiences;
            this._clientCodeVerifier = clientCodeVerifier;
            this._expiresIn = expiresIn;
            this._grantType = grantType;
            this._issuedAt = issuedAt;
            this._scopes = scopes;
            this._tokenKey = tokenKey;
            this._tokenType = tokenType;
            this._userId = userId;
            this._userName = userName;
        }

        public List<String> getAudiences() {
            return this._audiences;
        }

        public String getClientCodeVerifier() {
            return this._clientCodeVerifier;
        }

        public long getExpiresIn() {
            return this._expiresIn;
        }

        public String getGrantType() {
            return this._grantType;
        }

        public long getIssuedAt() {
            return this._issuedAt;
        }

        public OAuth2Application getOAuth2Application() {
            return this._oAuth2Application;
        }

        public List<String> getScopes() {
            return this._scopes;
        }

        public String getTokenKey() {
            return this._tokenKey;
        }

        public String getTokenType() {
            return this._tokenType;
        }

        public long getUserId() {
            return this._userId;
        }

        public String getUserName() {
            return this._userName;
        }

        public void setAudiences(List<String> audiences) {
            this._audiences = audiences;
        }

        public void setClientCodeVerifier(String clientCodeVerifier) {
            this._clientCodeVerifier = clientCodeVerifier;
        }

        public void setExpiresIn(long expiresIn) {
            this._expiresIn = expiresIn;
        }

        public void setGrantType(String grantType) {
            this._grantType = grantType;
        }

        public void setIssuedAt(long issuedAt) {
            this._issuedAt = issuedAt;
        }

        public void setOAuth2Application(OAuth2Application oAuth2Application) {
            this._oAuth2Application = oAuth2Application;
        }

        public void setScopes(List<String> scopes) {
            this._scopes = scopes;
        }

        public void setTokenKey(String tokenKey) {
            this._tokenKey = tokenKey;
        }

        public void setTokenType(String tokenType) {
            this._tokenType = tokenType;
        }

        public void setUserId(long userId) {
            this._userId = userId;
        }

        public void setUserName(String userName) {
            this._userName = userName;
        }
    }

    public static class AccessToken {
        private List<String> _audiences;
        private String _clientCodeVerifier;
        private long _expiresIn;
        private Map<String, String> _extraProperties;
        private String _grantCode;
        private String _grantType;
        private long _issuedAt;
        private String _issuer;
        private String _nonce;
        private OAuth2Application _oAuth2Application;
        private Map<String, String> _parameters;
        private String _refreshToken;
        private String _responseType;
        private List<String> _scopes;
        private String _tokenKey;
        private String _tokenType;
        private long _userId;
        private String _userName;

        public AccessToken(OAuth2Application oAuth2Application, List<String> audiences, String clientCodeVerifier, long expiresIn, Map<String, String> extraProperties, String grantCode, String grantType, long issuedAt, String issuer, String nonce, Map<String, String> parameters, String refreshToken, String responseType, List<String> scopes, String tokenKey, String tokenType, long userId, String userName) {
            this._oAuth2Application = oAuth2Application;
            this._audiences = audiences;
            this._clientCodeVerifier = clientCodeVerifier;
            this._expiresIn = expiresIn;
            this._extraProperties = extraProperties;
            this._grantCode = grantCode;
            this._grantType = grantType;
            this._issuedAt = issuedAt;
            this._issuer = issuer;
            this._nonce = nonce;
            this._parameters = parameters;
            this._refreshToken = refreshToken;
            this._responseType = responseType;
            this._scopes = scopes;
            this._tokenKey = tokenKey;
            this._tokenType = tokenType;
            this._userId = userId;
            this._userName = userName;
        }

        public List<String> getAudiences() {
            return this._audiences;
        }

        public String getClientCodeVerifier() {
            return this._clientCodeVerifier;
        }

        public long getExpiresIn() {
            return this._expiresIn;
        }

        public Map<String, String> getExtraProperties() {
            return this._extraProperties;
        }

        public String getGrantCode() {
            return this._grantCode;
        }

        public String getGrantType() {
            return this._grantType;
        }

        public long getIssuedAt() {
            return this._issuedAt;
        }

        public String getIssuer() {
            return this._issuer;
        }

        public String getNonce() {
            return this._nonce;
        }

        public OAuth2Application getOAuth2Application() {
            return this._oAuth2Application;
        }

        public Map<String, String> getParameters() {
            return this._parameters;
        }

        public String getRefreshToken() {
            return this._refreshToken;
        }

        public String getResponseType() {
            return this._responseType;
        }

        public List<String> getScopes() {
            return this._scopes;
        }

        public String getTokenKey() {
            return this._tokenKey;
        }

        public String getTokenType() {
            return this._tokenType;
        }

        public long getUserId() {
            return this._userId;
        }

        public String getUserName() {
            return this._userName;
        }

        public void setAudiences(List<String> audiences) {
            this._audiences = audiences;
        }

        public void setClientCodeVerifier(String clientCodeVerifier) {
            this._clientCodeVerifier = clientCodeVerifier;
        }

        public void setExpiresIn(long expiresIn) {
            this._expiresIn = expiresIn;
        }

        public void setExtraProperties(Map<String, String> extraProperties) {
            this._extraProperties = extraProperties;
        }

        public void setGrantCode(String grantCode) {
            this._grantCode = grantCode;
        }

        public void setGrantType(String grantType) {
            this._grantType = grantType;
        }

        public void setIssuedAt(long issuedAt) {
            this._issuedAt = issuedAt;
        }

        public void setIssuer(String issuer) {
            this._issuer = issuer;
        }

        public void setNonce(String nonce) {
            this._nonce = nonce;
        }

        public void setOAuth2Application(OAuth2Application oAuth2Application) {
            this._oAuth2Application = oAuth2Application;
        }

        public void setParameters(Map<String, String> parameters) {
            this._parameters = parameters;
        }

        public void setRefreshToken(String refreshToken) {
            this._refreshToken = refreshToken;
        }

        public void setResponseType(String responseType) {
            this._responseType = responseType;
        }

        public void setScopes(List<String> scopes) {
            this._scopes = scopes;
        }

        public void setTokenKey(String tokenKey) {
            this._tokenKey = tokenKey;
        }

        public void setTokenType(String tokenType) {
            this._tokenType = tokenType;
        }

        public void setUserId(long userId) {
            this._userId = userId;
        }

        public void setUserName(String userName) {
            this._userName = userName;
        }
    }
}

