/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.spi.scope.checker.container.request.filter;

import com.liferay.portal.kernel.security.access.control.AccessControlUtil;
import com.liferay.portal.kernel.security.auth.AccessControlContext;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifierResult;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Map;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;

public abstract class BaseScopeCheckerContainerRequestFilter
implements ContainerRequestFilter {
    public void filter(ContainerRequestContext containerRequestContext) {
        if (this.isOAuth2AuthVerified() && !this.isContainerRequestContextAllowed(containerRequestContext)) {
            containerRequestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
        }
    }

    protected abstract boolean isContainerRequestContextAllowed(ContainerRequestContext var1);

    protected boolean isOAuth2AuthVerified() {
        Map settings;
        String authType;
        AccessControlContext accessControlContext = AccessControlUtil.getAccessControlContext();
        AuthVerifierResult authVerifierResult = accessControlContext.getAuthVerifierResult();
        return authVerifierResult == null || !AuthVerifierResult.State.SUCCESS.equals((Object)authVerifierResult.getState()) || !Validator.isNotNull((String)(authType = MapUtil.getString((Map)(settings = authVerifierResult.getSettings()), (String)"auth.type"))) || authType.equals("OAuth2");
    }
}

