/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.jsonws.internal.servlet.filters.authverifier;

import com.liferay.portal.kernel.security.access.control.AccessControlThreadLocal;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifierConfiguration;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.authverifier.AuthVerifierFilter;
import java.util.Dictionary;
import java.util.Map;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(immediate=true, property={"before-filter=Auto Login Filter", "dispatcher=FORWARD", "dispatcher=REQUEST", "servlet-context-name=", "servlet-filter-name=OAuth2 Web Server Servlet Auth Verifier Filter", "url-pattern=/c/portal/fragment/*", "url-pattern=/c/portal/layout_page_template/*", "url-pattern=/documents/*", "url-pattern=/image/*"}, service={Filter.class})
public class OAuth2WebServerServletAuthVerifierFilter
extends AuthVerifierFilter {
    private ServiceRegistration<AuthVerifierConfiguration> _serviceRegistration;

    public boolean isFilterEnabled(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String authorization = httpServletRequest.getHeader("Authorization");
        if (Validator.isBlank((String)authorization) || !StringUtil.startsWith((String)authorization, (String)"Bearer")) {
            return false;
        }
        return super.isFilterEnabled(httpServletRequest, httpServletResponse);
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> propertiesMap) {
        AuthVerifierConfiguration authVerifierConfiguration = new AuthVerifierConfiguration();
        authVerifierConfiguration.setAuthVerifierClassName("OAuth2JSONWSAuthVerifier");
        Properties properties = new Properties();
        properties.put("urls.includes", StringUtil.merge((Object[])((Object[])propertiesMap.get("url-pattern")), (String)","));
        authVerifierConfiguration.setProperties(properties);
        this._serviceRegistration = bundleContext.registerService(AuthVerifierConfiguration.class, (Object)authVerifierConfiguration, (Dictionary)new HashMapDictionary());
    }

    @Deactivate
    protected void deactivate() {
        this._serviceRegistration.unregister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processFilter(String logName, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws Exception {
        boolean remoteAccess = AccessControlThreadLocal.isRemoteAccess();
        AccessControlThreadLocal.setRemoteAccess((boolean)true);
        try {
            super.processFilter(logName, httpServletRequest, httpServletResponse, filterChain);
        }
        finally {
            AccessControlThreadLocal.setRemoteAccess((boolean)remoteAccess);
        }
    }
}

