/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.jsonws.internal.service.access.policy.scope;

import com.liferay.oauth2.provider.jsonws.internal.configuration.OAuth2JSONWSConfiguration;
import com.liferay.oauth2.provider.jsonws.internal.service.access.policy.scope.SAPEntryScope;
import com.liferay.oauth2.provider.jsonws.internal.service.access.policy.scope.SAPEntryScopeDescriptorFinder;
import com.liferay.oauth2.provider.scope.spi.scope.descriptor.ScopeDescriptor;
import com.liferay.oauth2.provider.scope.spi.scope.finder.ScopeFinder;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.service.access.policy.model.SAPEntry;
import com.liferay.portal.security.service.access.policy.service.SAPEntryLocalService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(configurationPid={"com.liferay.oauth2.provider.jsonws.internal.configuration.OAuth2JSONWSConfiguration"}, immediate=true, service={SAPEntryScopeDescriptorFinderRegistrator.class})
public class SAPEntryScopeDescriptorFinderRegistrator {
    private static final Log _log = LogFactoryUtil.getLog(SAPEntryScopeDescriptorFinderRegistrator.class);
    private BundleContext _bundleContext;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference(target="(default=true)")
    private ScopeDescriptor _defaultScopeDescriptor;
    private final Set<String> _jaxRsApplicationNames = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<Long, List<SAPEntryScope>> _registeredSAPEntryScopes = new ConcurrentHashMap<Long, List<SAPEntryScope>>();
    private boolean _removeSAPEntryOAuth2Prefix = true;
    @Reference
    private SAPEntryLocalService _sapEntryLocalService;
    private String _sapEntryOAuth2Prefix = "OAUTH2_";
    private final Map<Long, ServiceRegistration<ScopeDescriptor>> _scopeDescriptorServiceRegistrations = new ConcurrentHashMap<Long, ServiceRegistration<ScopeDescriptor>>();
    private final Map<Long, ServiceRegistration<ScopeFinder>> _scopeFinderServiceRegistrations = new ConcurrentHashMap<Long, ServiceRegistration<ScopeFinder>>();

    public List<SAPEntryScope> getRegisteredSAPEntryScopes(long companyId) {
        return new ArrayList<SAPEntryScope>((Collection)this._registeredSAPEntryScopes.get(companyId));
    }

    public void register(long companyId) {
        try {
            List<SAPEntryScope> sapEntryScopes = this._loadSAPEntryScopes(companyId);
            SAPEntryScopeDescriptorFinder sapEntryScopeDescriptorFinder = new SAPEntryScopeDescriptorFinder(sapEntryScopes, this._defaultScopeDescriptor);
            this._scopeDescriptorServiceRegistrations.compute(companyId, (key, serviceRegistration) -> {
                if (serviceRegistration != null) {
                    serviceRegistration.unregister();
                }
                return this._bundleContext.registerService(ScopeDescriptor.class, (Object)sapEntryScopeDescriptorFinder, this._buildScopeDescriptorProperties(companyId));
            });
            HashMapDictionary properties = HashMapDictionaryBuilder.put((Object)"companyId", (Object)String.valueOf(companyId)).put((Object)"osgi.jaxrs.name", (Object)"liferay-json-web-services").put((Object)"sap.scope.finder", (Object)Boolean.TRUE).build();
            this._scopeFinderServiceRegistrations.compute(companyId, (arg_0, arg_1) -> this.lambda$register$1(sapEntryScopeDescriptorFinder, (Dictionary)properties, companyId, sapEntryScopes, arg_0, arg_1));
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to register SAP entry scope descriptor finder for company " + companyId), (Throwable)exception);
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._bundleContext = bundleContext;
        OAuth2JSONWSConfiguration oAuth2JSONWSConfiguration = (OAuth2JSONWSConfiguration)ConfigurableUtil.createConfigurable(OAuth2JSONWSConfiguration.class, properties);
        this._removeSAPEntryOAuth2Prefix = oAuth2JSONWSConfiguration.removeSAPEntryOAuth2Prefix();
        this._sapEntryOAuth2Prefix = oAuth2JSONWSConfiguration.sapEntryOAuth2Prefix();
        this._companyLocalService.forEachCompanyId(companyId -> this.register((long)companyId), ArrayUtil.toLongArray(this._scopeFinderServiceRegistrations.keySet()));
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(&(osgi.jaxrs.name=*)(sap.scope.finder=true))")
    protected void addJaxRsApplicationName(ServiceReference<ScopeFinder> serviceReference) {
        this._jaxRsApplicationNames.add(GetterUtil.getString((Object)serviceReference.getProperty("osgi.jaxrs.name")));
        for (Map.Entry<Long, ServiceRegistration<ScopeDescriptor>> entry : this._scopeDescriptorServiceRegistrations.entrySet()) {
            ServiceRegistration<ScopeDescriptor> serviceRegistration = entry.getValue();
            try {
                serviceRegistration.setProperties(this._buildScopeDescriptorProperties(entry.getKey()));
            }
            catch (IllegalStateException illegalStateException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)illegalStateException);
            }
        }
    }

    @Deactivate
    protected void deactivate() {
        for (ServiceRegistration<ScopeFinder> serviceRegistration : this._scopeFinderServiceRegistrations.values()) {
            serviceRegistration.unregister();
        }
        this._scopeFinderServiceRegistrations.clear();
        for (ServiceRegistration<ScopeFinder> serviceRegistration : this._scopeDescriptorServiceRegistrations.values()) {
            serviceRegistration.unregister();
        }
        this._scopeDescriptorServiceRegistrations.clear();
    }

    protected void removeJaxRsApplicationName(ServiceReference<ScopeFinder> serviceReference) {
        this._jaxRsApplicationNames.remove(GetterUtil.getString((Object)serviceReference.getProperty("osgi.jaxrs.name")));
        for (Map.Entry<Long, ServiceRegistration<ScopeDescriptor>> entry : this._scopeDescriptorServiceRegistrations.entrySet()) {
            ServiceRegistration<ScopeDescriptor> serviceRegistration = entry.getValue();
            try {
                serviceRegistration.setProperties(this._buildScopeDescriptorProperties(entry.getKey()));
            }
            catch (IllegalStateException illegalStateException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)illegalStateException);
            }
        }
    }

    private HashMapDictionary<String, Object> _buildScopeDescriptorProperties(long companyId) {
        return HashMapDictionaryBuilder.put((Object)"companyId", (Object)String.valueOf(companyId)).put((Object)"osgi.jaxrs.name", (Object)this._jaxRsApplicationNames.toArray(new String[0])).build();
    }

    private boolean _isOAuth2ExportedSAPEntry(SAPEntry sapEntry) {
        return StringUtil.startsWith((String)sapEntry.getName(), (String)this._sapEntryOAuth2Prefix);
    }

    private List<SAPEntryScope> _loadSAPEntryScopes(long companyId) {
        ArrayList<SAPEntryScope> sapEntryScopes = new ArrayList<SAPEntryScope>();
        for (SAPEntry sapEntry : this._sapEntryLocalService.getCompanySAPEntries(companyId, -1, -1)) {
            if (!this._isOAuth2ExportedSAPEntry(sapEntry)) continue;
            sapEntryScopes.add(new SAPEntryScope(sapEntry, this._parseScope(sapEntry)));
        }
        return sapEntryScopes;
    }

    private String _parseScope(SAPEntry sapEntry) {
        String sapEntryName = sapEntry.getName();
        if (!this._removeSAPEntryOAuth2Prefix) {
            return sapEntryName;
        }
        return sapEntryName.substring(this._sapEntryOAuth2Prefix.length());
    }

    private /* synthetic */ ServiceRegistration lambda$register$1(SAPEntryScopeDescriptorFinder sapEntryScopeDescriptorFinder, Dictionary properties, long companyId, List sapEntryScopes, Long key, ServiceRegistration serviceRegistration) {
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
        serviceRegistration = this._bundleContext.registerService(ScopeFinder.class, (Object)sapEntryScopeDescriptorFinder, properties);
        this._registeredSAPEntryScopes.put(companyId, sapEntryScopes);
        return serviceRegistration;
    }
}

