/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.jsonws.internal.service.access.policy.scope;

import com.liferay.oauth2.provider.jsonws.internal.service.access.policy.scope.SAPEntryScope;
import com.liferay.oauth2.provider.scope.spi.scope.descriptor.ScopeDescriptor;
import com.liferay.oauth2.provider.scope.spi.scope.finder.ScopeFinder;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.security.service.access.policy.model.SAPEntry;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class SAPEntryScopeDescriptorFinder
implements ScopeDescriptor,
ScopeFinder {
    private static final Log _log = LogFactoryUtil.getLog(SAPEntryScopeDescriptorFinder.class);
    private final ScopeDescriptor _defaultScopeDescriptor;
    private final Map<String, SAPEntryScope> _sapEntryScopes = new HashMap<String, SAPEntryScope>();
    private final Set<String> _scopes = new HashSet<String>();

    public SAPEntryScopeDescriptorFinder(List<SAPEntryScope> sapEntryScopes, ScopeDescriptor defaultScopeDescriptor) {
        this._defaultScopeDescriptor = defaultScopeDescriptor;
        for (SAPEntryScope sapEntryScope : sapEntryScopes) {
            SAPEntry sapEntry = sapEntryScope.getSAPEntry();
            if (sapEntry.isEnabled()) {
                this._scopes.add(sapEntryScope.getScope());
            }
            this._sapEntryScopes.put(sapEntryScope.getScope(), sapEntryScope);
        }
    }

    public String describeScope(String scope, Locale locale) {
        SAPEntryScope sapEntryScope = this._sapEntryScopes.get(scope);
        if (sapEntryScope == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to get SAP entry scope " + scope));
            }
            return this._defaultScopeDescriptor.describeScope(scope, locale);
        }
        return sapEntryScope.getTitle(locale);
    }

    public Collection<String> findScopes() {
        return new HashSet<String>(this._scopes);
    }
}

