/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.oauth2.provider.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ShardedModel;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the OAuth2ScopeGrant service. Represents a row in the &quot;OAuth2ScopeGrant&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.oauth2.provider.model.impl.OAuth2ScopeGrantModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.oauth2.provider.model.impl.OAuth2ScopeGrantImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see OAuth2ScopeGrant
 * @generated
 */
@ProviderType
public interface OAuth2ScopeGrantModel
	extends BaseModel<OAuth2ScopeGrant>, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a o auth2 scope grant model instance should use the {@link OAuth2ScopeGrant} interface instead.
	 */

	/**
	 * Returns the primary key of this o auth2 scope grant.
	 *
	 * @return the primary key of this o auth2 scope grant
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this o auth2 scope grant.
	 *
	 * @param primaryKey the primary key of this o auth2 scope grant
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the o auth2 scope grant ID of this o auth2 scope grant.
	 *
	 * @return the o auth2 scope grant ID of this o auth2 scope grant
	 */
	public long getOAuth2ScopeGrantId();

	/**
	 * Sets the o auth2 scope grant ID of this o auth2 scope grant.
	 *
	 * @param oAuth2ScopeGrantId the o auth2 scope grant ID of this o auth2 scope grant
	 */
	public void setOAuth2ScopeGrantId(long oAuth2ScopeGrantId);

	/**
	 * Returns the company ID of this o auth2 scope grant.
	 *
	 * @return the company ID of this o auth2 scope grant
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this o auth2 scope grant.
	 *
	 * @param companyId the company ID of this o auth2 scope grant
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the o auth2 application scope aliases ID of this o auth2 scope grant.
	 *
	 * @return the o auth2 application scope aliases ID of this o auth2 scope grant
	 */
	public long getOAuth2ApplicationScopeAliasesId();

	/**
	 * Sets the o auth2 application scope aliases ID of this o auth2 scope grant.
	 *
	 * @param oAuth2ApplicationScopeAliasesId the o auth2 application scope aliases ID of this o auth2 scope grant
	 */
	public void setOAuth2ApplicationScopeAliasesId(
		long oAuth2ApplicationScopeAliasesId);

	/**
	 * Returns the application name of this o auth2 scope grant.
	 *
	 * @return the application name of this o auth2 scope grant
	 */
	@AutoEscape
	public String getApplicationName();

	/**
	 * Sets the application name of this o auth2 scope grant.
	 *
	 * @param applicationName the application name of this o auth2 scope grant
	 */
	public void setApplicationName(String applicationName);

	/**
	 * Returns the bundle symbolic name of this o auth2 scope grant.
	 *
	 * @return the bundle symbolic name of this o auth2 scope grant
	 */
	@AutoEscape
	public String getBundleSymbolicName();

	/**
	 * Sets the bundle symbolic name of this o auth2 scope grant.
	 *
	 * @param bundleSymbolicName the bundle symbolic name of this o auth2 scope grant
	 */
	public void setBundleSymbolicName(String bundleSymbolicName);

	/**
	 * Returns the scope of this o auth2 scope grant.
	 *
	 * @return the scope of this o auth2 scope grant
	 */
	@AutoEscape
	public String getScope();

	/**
	 * Sets the scope of this o auth2 scope grant.
	 *
	 * @param scope the scope of this o auth2 scope grant
	 */
	public void setScope(String scope);

	/**
	 * Returns the scope aliases of this o auth2 scope grant.
	 *
	 * @return the scope aliases of this o auth2 scope grant
	 */
	@AutoEscape
	public String getScopeAliases();

	/**
	 * Sets the scope aliases of this o auth2 scope grant.
	 *
	 * @param scopeAliases the scope aliases of this o auth2 scope grant
	 */
	public void setScopeAliases(String scopeAliases);

	@Override
	public OAuth2ScopeGrant cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}