/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.oauth2.provider.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ExternalReferenceCodeModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedAuditedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the OAuth2Application service. Represents a row in the &quot;OAuth2Application&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.oauth2.provider.model.impl.OAuth2ApplicationModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.oauth2.provider.model.impl.OAuth2ApplicationImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see OAuth2Application
 * @generated
 */
@ProviderType
public interface OAuth2ApplicationModel
	extends BaseModel<OAuth2Application>, ExternalReferenceCodeModel,
			ShardedModel, StagedAuditedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a o auth2 application model instance should use the {@link OAuth2Application} interface instead.
	 */

	/**
	 * Returns the primary key of this o auth2 application.
	 *
	 * @return the primary key of this o auth2 application
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this o auth2 application.
	 *
	 * @param primaryKey the primary key of this o auth2 application
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the uuid of this o auth2 application.
	 *
	 * @return the uuid of this o auth2 application
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this o auth2 application.
	 *
	 * @param uuid the uuid of this o auth2 application
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the external reference code of this o auth2 application.
	 *
	 * @return the external reference code of this o auth2 application
	 */
	@AutoEscape
	@Override
	public String getExternalReferenceCode();

	/**
	 * Sets the external reference code of this o auth2 application.
	 *
	 * @param externalReferenceCode the external reference code of this o auth2 application
	 */
	@Override
	public void setExternalReferenceCode(String externalReferenceCode);

	/**
	 * Returns the o auth2 application ID of this o auth2 application.
	 *
	 * @return the o auth2 application ID of this o auth2 application
	 */
	public long getOAuth2ApplicationId();

	/**
	 * Sets the o auth2 application ID of this o auth2 application.
	 *
	 * @param oAuth2ApplicationId the o auth2 application ID of this o auth2 application
	 */
	public void setOAuth2ApplicationId(long oAuth2ApplicationId);

	/**
	 * Returns the company ID of this o auth2 application.
	 *
	 * @return the company ID of this o auth2 application
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this o auth2 application.
	 *
	 * @param companyId the company ID of this o auth2 application
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this o auth2 application.
	 *
	 * @return the user ID of this o auth2 application
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this o auth2 application.
	 *
	 * @param userId the user ID of this o auth2 application
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this o auth2 application.
	 *
	 * @return the user uuid of this o auth2 application
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this o auth2 application.
	 *
	 * @param userUuid the user uuid of this o auth2 application
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this o auth2 application.
	 *
	 * @return the user name of this o auth2 application
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this o auth2 application.
	 *
	 * @param userName the user name of this o auth2 application
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this o auth2 application.
	 *
	 * @return the create date of this o auth2 application
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this o auth2 application.
	 *
	 * @param createDate the create date of this o auth2 application
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this o auth2 application.
	 *
	 * @return the modified date of this o auth2 application
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this o auth2 application.
	 *
	 * @param modifiedDate the modified date of this o auth2 application
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the o auth2 application scope aliases ID of this o auth2 application.
	 *
	 * @return the o auth2 application scope aliases ID of this o auth2 application
	 */
	public long getOAuth2ApplicationScopeAliasesId();

	/**
	 * Sets the o auth2 application scope aliases ID of this o auth2 application.
	 *
	 * @param oAuth2ApplicationScopeAliasesId the o auth2 application scope aliases ID of this o auth2 application
	 */
	public void setOAuth2ApplicationScopeAliasesId(
		long oAuth2ApplicationScopeAliasesId);

	/**
	 * Returns the allowed grant types of this o auth2 application.
	 *
	 * @return the allowed grant types of this o auth2 application
	 */
	@AutoEscape
	public String getAllowedGrantTypes();

	/**
	 * Sets the allowed grant types of this o auth2 application.
	 *
	 * @param allowedGrantTypes the allowed grant types of this o auth2 application
	 */
	public void setAllowedGrantTypes(String allowedGrantTypes);

	/**
	 * Returns the client authentication method of this o auth2 application.
	 *
	 * @return the client authentication method of this o auth2 application
	 */
	@AutoEscape
	public String getClientAuthenticationMethod();

	/**
	 * Sets the client authentication method of this o auth2 application.
	 *
	 * @param clientAuthenticationMethod the client authentication method of this o auth2 application
	 */
	public void setClientAuthenticationMethod(
		String clientAuthenticationMethod);

	/**
	 * Returns the client credential user ID of this o auth2 application.
	 *
	 * @return the client credential user ID of this o auth2 application
	 */
	public long getClientCredentialUserId();

	/**
	 * Sets the client credential user ID of this o auth2 application.
	 *
	 * @param clientCredentialUserId the client credential user ID of this o auth2 application
	 */
	public void setClientCredentialUserId(long clientCredentialUserId);

	/**
	 * Returns the client credential user uuid of this o auth2 application.
	 *
	 * @return the client credential user uuid of this o auth2 application
	 */
	public String getClientCredentialUserUuid();

	/**
	 * Sets the client credential user uuid of this o auth2 application.
	 *
	 * @param clientCredentialUserUuid the client credential user uuid of this o auth2 application
	 */
	public void setClientCredentialUserUuid(String clientCredentialUserUuid);

	/**
	 * Returns the client credential user name of this o auth2 application.
	 *
	 * @return the client credential user name of this o auth2 application
	 */
	@AutoEscape
	public String getClientCredentialUserName();

	/**
	 * Sets the client credential user name of this o auth2 application.
	 *
	 * @param clientCredentialUserName the client credential user name of this o auth2 application
	 */
	public void setClientCredentialUserName(String clientCredentialUserName);

	/**
	 * Returns the client ID of this o auth2 application.
	 *
	 * @return the client ID of this o auth2 application
	 */
	@AutoEscape
	public String getClientId();

	/**
	 * Sets the client ID of this o auth2 application.
	 *
	 * @param clientId the client ID of this o auth2 application
	 */
	public void setClientId(String clientId);

	/**
	 * Returns the client profile of this o auth2 application.
	 *
	 * @return the client profile of this o auth2 application
	 */
	public int getClientProfile();

	/**
	 * Sets the client profile of this o auth2 application.
	 *
	 * @param clientProfile the client profile of this o auth2 application
	 */
	public void setClientProfile(int clientProfile);

	/**
	 * Returns the client secret of this o auth2 application.
	 *
	 * @return the client secret of this o auth2 application
	 */
	@AutoEscape
	public String getClientSecret();

	/**
	 * Sets the client secret of this o auth2 application.
	 *
	 * @param clientSecret the client secret of this o auth2 application
	 */
	public void setClientSecret(String clientSecret);

	/**
	 * Returns the description of this o auth2 application.
	 *
	 * @return the description of this o auth2 application
	 */
	@AutoEscape
	public String getDescription();

	/**
	 * Sets the description of this o auth2 application.
	 *
	 * @param description the description of this o auth2 application
	 */
	public void setDescription(String description);

	/**
	 * Returns the features of this o auth2 application.
	 *
	 * @return the features of this o auth2 application
	 */
	@AutoEscape
	public String getFeatures();

	/**
	 * Sets the features of this o auth2 application.
	 *
	 * @param features the features of this o auth2 application
	 */
	public void setFeatures(String features);

	/**
	 * Returns the home page url of this o auth2 application.
	 *
	 * @return the home page url of this o auth2 application
	 */
	@AutoEscape
	public String getHomePageURL();

	/**
	 * Sets the home page url of this o auth2 application.
	 *
	 * @param homePageURL the home page url of this o auth2 application
	 */
	public void setHomePageURL(String homePageURL);

	/**
	 * Returns the icon file entry ID of this o auth2 application.
	 *
	 * @return the icon file entry ID of this o auth2 application
	 */
	public long getIconFileEntryId();

	/**
	 * Sets the icon file entry ID of this o auth2 application.
	 *
	 * @param iconFileEntryId the icon file entry ID of this o auth2 application
	 */
	public void setIconFileEntryId(long iconFileEntryId);

	/**
	 * Returns the jwks of this o auth2 application.
	 *
	 * @return the jwks of this o auth2 application
	 */
	@AutoEscape
	public String getJwks();

	/**
	 * Sets the jwks of this o auth2 application.
	 *
	 * @param jwks the jwks of this o auth2 application
	 */
	public void setJwks(String jwks);

	/**
	 * Returns the name of this o auth2 application.
	 *
	 * @return the name of this o auth2 application
	 */
	@AutoEscape
	public String getName();

	/**
	 * Sets the name of this o auth2 application.
	 *
	 * @param name the name of this o auth2 application
	 */
	public void setName(String name);

	/**
	 * Returns the privacy policy url of this o auth2 application.
	 *
	 * @return the privacy policy url of this o auth2 application
	 */
	@AutoEscape
	public String getPrivacyPolicyURL();

	/**
	 * Sets the privacy policy url of this o auth2 application.
	 *
	 * @param privacyPolicyURL the privacy policy url of this o auth2 application
	 */
	public void setPrivacyPolicyURL(String privacyPolicyURL);

	/**
	 * Returns the redirect ur is of this o auth2 application.
	 *
	 * @return the redirect ur is of this o auth2 application
	 */
	@AutoEscape
	public String getRedirectURIs();

	/**
	 * Sets the redirect ur is of this o auth2 application.
	 *
	 * @param redirectURIs the redirect ur is of this o auth2 application
	 */
	public void setRedirectURIs(String redirectURIs);

	/**
	 * Returns the remember device of this o auth2 application.
	 *
	 * @return the remember device of this o auth2 application
	 */
	public boolean getRememberDevice();

	/**
	 * Returns <code>true</code> if this o auth2 application is remember device.
	 *
	 * @return <code>true</code> if this o auth2 application is remember device; <code>false</code> otherwise
	 */
	public boolean isRememberDevice();

	/**
	 * Sets whether this o auth2 application is remember device.
	 *
	 * @param rememberDevice the remember device of this o auth2 application
	 */
	public void setRememberDevice(boolean rememberDevice);

	/**
	 * Returns the trusted application of this o auth2 application.
	 *
	 * @return the trusted application of this o auth2 application
	 */
	public boolean getTrustedApplication();

	/**
	 * Returns <code>true</code> if this o auth2 application is trusted application.
	 *
	 * @return <code>true</code> if this o auth2 application is trusted application; <code>false</code> otherwise
	 */
	public boolean isTrustedApplication();

	/**
	 * Sets whether this o auth2 application is trusted application.
	 *
	 * @param trustedApplication the trusted application of this o auth2 application
	 */
	public void setTrustedApplication(boolean trustedApplication);

	@Override
	public OAuth2Application cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}