/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.constants;

import com.liferay.oauth2.provider.constants.GrantType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public enum ClientProfile {
    HEADLESS_SERVER(4, GrantType.CLIENT_CREDENTIALS, GrantType.JWT_BEARER),
    NATIVE_APPLICATION(1, GrantType.AUTHORIZATION_CODE_PKCE, GrantType.JWT_BEARER, GrantType.RESOURCE_OWNER_PASSWORD, GrantType.REFRESH_TOKEN),
    OTHER(5, GrantType.values()),
    USER_AGENT_APPLICATION(2, GrantType.AUTHORIZATION_CODE_PKCE, GrantType.JWT_BEARER),
    WEB_APPLICATION(0, GrantType.AUTHORIZATION_CODE, GrantType.CLIENT_CREDENTIALS, GrantType.JWT_BEARER, GrantType.REFRESH_TOKEN, GrantType.RESOURCE_OWNER_PASSWORD);

    private final Set<GrantType> _grantTypes;
    private final int _id;

    public Set<GrantType> grantTypes() {
        return this._grantTypes;
    }

    public int id() {
        return this._id;
    }

    private ClientProfile(int id, GrantType ... grantTypes) {
        this._id = id;
        this._grantTypes = Collections.unmodifiableSet(new HashSet<GrantType>(Arrays.asList(grantTypes)));
    }
}

