/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth.client.persistence.service.impl;

import com.liferay.oauth.client.persistence.model.OAuthClientEntry;
import com.liferay.oauth.client.persistence.service.base.OAuthClientEntryServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionUtil;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=oauthclient", "json.web.service.context.path=OAuthClientEntry"}, service={AopService.class})
public class OAuthClientEntryServiceImpl
extends OAuthClientEntryServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.oauth.client.persistence.model.OAuthClientEntry)")
    private ModelResourcePermission<OAuthClientEntry> _oAuthClientEntryModelResourcePermission;

    public OAuthClientEntry addOAuthClientEntry(long userId, String authRequestParametersJSON, String authServerWellKnownURI, String infoJSON, String oidcUserInfoMapperJSON, String tokenRequestParametersJSON) throws PortalException {
        ModelResourcePermissionUtil.check(this._oAuthClientEntryModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)0L, (long)0L, (String)"ADD_OAUTH_CLIENT_ENTRY");
        return this.oAuthClientEntryLocalService.addOAuthClientEntry(userId, authRequestParametersJSON, authServerWellKnownURI, infoJSON, oidcUserInfoMapperJSON, tokenRequestParametersJSON);
    }

    public OAuthClientEntry deleteOAuthClientEntry(long oAuthClientEntryId) throws PortalException {
        OAuthClientEntry oAuthClientEntry = this.oAuthClientEntryLocalService.getOAuthClientEntry(oAuthClientEntryId);
        this._oAuthClientEntryModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)oAuthClientEntry, "DELETE");
        return this.oAuthClientEntryLocalService.deleteOAuthClientEntry(oAuthClientEntry);
    }

    public OAuthClientEntry deleteOAuthClientEntry(long companyId, String authServerWellKnownURI, String clientId) throws PortalException {
        OAuthClientEntry oAuthClientEntry = this.oAuthClientEntryLocalService.getOAuthClientEntry(companyId, authServerWellKnownURI, clientId);
        this._oAuthClientEntryModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)oAuthClientEntry, "DELETE");
        return this.oAuthClientEntryLocalService.deleteOAuthClientEntry(oAuthClientEntry);
    }

    public List<OAuthClientEntry> getAuthServerWellKnownURISuffixOAuthClientEntries(long companyId, String authServerWellKnownURISuffix) throws PortalException {
        List oAuthClientEntries = this.oAuthClientEntryLocalService.getAuthServerWellKnownURISuffixOAuthClientEntries(companyId, authServerWellKnownURISuffix);
        for (OAuthClientEntry oAuthClientEntry : oAuthClientEntries) {
            this._oAuthClientEntryModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)oAuthClientEntry, "VIEW");
        }
        return oAuthClientEntries;
    }

    public List<OAuthClientEntry> getCompanyOAuthClientEntries(long companyId) {
        return this.oAuthClientEntryPersistence.filterFindByCompanyId(companyId);
    }

    public List<OAuthClientEntry> getCompanyOAuthClientEntries(long companyId, int start, int end) {
        return this.oAuthClientEntryPersistence.filterFindByCompanyId(companyId, start, end);
    }

    public OAuthClientEntry getOAuthClientEntry(long companyId, String authServerWellKnownURI, String clientId) throws PortalException {
        OAuthClientEntry oAuthClientEntry = this.oAuthClientEntryLocalService.getOAuthClientEntry(companyId, authServerWellKnownURI, clientId);
        this._oAuthClientEntryModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)oAuthClientEntry, "VIEW");
        return oAuthClientEntry;
    }

    public List<OAuthClientEntry> getUserOAuthClientEntries(long userId) {
        return this.oAuthClientEntryPersistence.filterFindByUserId(userId);
    }

    public List<OAuthClientEntry> getUserOAuthClientEntries(long userId, int start, int end) {
        return this.oAuthClientEntryPersistence.filterFindByUserId(userId, start, end);
    }

    public OAuthClientEntry updateOAuthClientEntry(long oAuthClientEntryId, String authRequestParametersJSON, String authServerWellKnownURI, String infoJSON, String oidcUserInfoMapperJSON, String tokenRequestParametersJSON) throws PortalException {
        this._oAuthClientEntryModelResourcePermission.check(this.getPermissionChecker(), oAuthClientEntryId, "UPDATE");
        return this.oAuthClientEntryLocalService.updateOAuthClientEntry(oAuthClientEntryId, authRequestParametersJSON, authServerWellKnownURI, infoJSON, oidcUserInfoMapperJSON, tokenRequestParametersJSON);
    }
}

