/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth.client.persistence.internal.security.permission.resource;

import com.liferay.oauth.client.persistence.model.OAuthClientEntry;
import com.liferay.oauth.client.persistence.service.OAuthClientEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.oauth.client.persistence.model.OAuthClientEntry"}, service={ModelResourcePermission.class})
public class OAuthClientEntryModelResourcePermission
implements ModelResourcePermission<OAuthClientEntry> {
    @Reference
    private OAuthClientEntryLocalService _oAuthClientEntryLocalService;
    @Reference(target="(resource.name=com.liferay.oauth.client.persistence)")
    private PortletResourcePermission _portletResourcePermission;

    public void check(PermissionChecker permissionChecker, long oAuthClientEntryId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, oAuthClientEntryId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, OAuthClientEntry.class.getName(), oAuthClientEntryId, new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, OAuthClientEntry oAuthClientEntry, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, oAuthClientEntry, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, OAuthClientEntry.class.getName(), oAuthClientEntry.getOAuthClientEntryId(), new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, long oAuthClientEntryId, String actionId) throws PortalException {
        return this.contains(permissionChecker, this._oAuthClientEntryLocalService.getOAuthClientEntry(oAuthClientEntryId), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, OAuthClientEntry oAuthClientEntry, String actionId) throws PortalException {
        if (permissionChecker.hasOwnerPermission(oAuthClientEntry.getCompanyId(), OAuthClientEntry.class.getName(), oAuthClientEntry.getOAuthClientEntryId(), oAuthClientEntry.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(null, OAuthClientEntry.class.getName(), oAuthClientEntry.getOAuthClientEntryId(), actionId);
    }

    public String getModelName() {
        return OAuthClientEntry.class.getName();
    }

    public PortletResourcePermission getPortletResourcePermission() {
        return this._portletResourcePermission;
    }
}

