/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.oauth.client.persistence.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the OAuthClientASLocalMetadata service. Represents a row in the &quot;OAuthClientASLocalMetadata&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.oauth.client.persistence.model.impl.OAuthClientASLocalMetadataModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.oauth.client.persistence.model.impl.OAuthClientASLocalMetadataImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see OAuthClientASLocalMetadata
 * @generated
 */
@ProviderType
public interface OAuthClientASLocalMetadataModel
	extends AuditedModel, BaseModel<OAuthClientASLocalMetadata>, MVCCModel,
			ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a o auth client as local metadata model instance should use the {@link OAuthClientASLocalMetadata} interface instead.
	 */

	/**
	 * Returns the primary key of this o auth client as local metadata.
	 *
	 * @return the primary key of this o auth client as local metadata
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this o auth client as local metadata.
	 *
	 * @param primaryKey the primary key of this o auth client as local metadata
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this o auth client as local metadata.
	 *
	 * @return the mvcc version of this o auth client as local metadata
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this o auth client as local metadata.
	 *
	 * @param mvccVersion the mvcc version of this o auth client as local metadata
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the o auth client as local metadata ID of this o auth client as local metadata.
	 *
	 * @return the o auth client as local metadata ID of this o auth client as local metadata
	 */
	public long getOAuthClientASLocalMetadataId();

	/**
	 * Sets the o auth client as local metadata ID of this o auth client as local metadata.
	 *
	 * @param oAuthClientASLocalMetadataId the o auth client as local metadata ID of this o auth client as local metadata
	 */
	public void setOAuthClientASLocalMetadataId(
		long oAuthClientASLocalMetadataId);

	/**
	 * Returns the company ID of this o auth client as local metadata.
	 *
	 * @return the company ID of this o auth client as local metadata
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this o auth client as local metadata.
	 *
	 * @param companyId the company ID of this o auth client as local metadata
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this o auth client as local metadata.
	 *
	 * @return the user ID of this o auth client as local metadata
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this o auth client as local metadata.
	 *
	 * @param userId the user ID of this o auth client as local metadata
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this o auth client as local metadata.
	 *
	 * @return the user uuid of this o auth client as local metadata
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this o auth client as local metadata.
	 *
	 * @param userUuid the user uuid of this o auth client as local metadata
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this o auth client as local metadata.
	 *
	 * @return the user name of this o auth client as local metadata
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this o auth client as local metadata.
	 *
	 * @param userName the user name of this o auth client as local metadata
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this o auth client as local metadata.
	 *
	 * @return the create date of this o auth client as local metadata
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this o auth client as local metadata.
	 *
	 * @param createDate the create date of this o auth client as local metadata
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this o auth client as local metadata.
	 *
	 * @return the modified date of this o auth client as local metadata
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this o auth client as local metadata.
	 *
	 * @param modifiedDate the modified date of this o auth client as local metadata
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the local well known uri of this o auth client as local metadata.
	 *
	 * @return the local well known uri of this o auth client as local metadata
	 */
	@AutoEscape
	public String getLocalWellKnownURI();

	/**
	 * Sets the local well known uri of this o auth client as local metadata.
	 *
	 * @param localWellKnownURI the local well known uri of this o auth client as local metadata
	 */
	public void setLocalWellKnownURI(String localWellKnownURI);

	/**
	 * Returns the metadata json of this o auth client as local metadata.
	 *
	 * @return the metadata json of this o auth client as local metadata
	 */
	@AutoEscape
	public String getMetadataJSON();

	/**
	 * Sets the metadata json of this o auth client as local metadata.
	 *
	 * @param metadataJSON the metadata json of this o auth client as local metadata
	 */
	public void setMetadataJSON(String metadataJSON);

	@Override
	public OAuthClientASLocalMetadata cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}