/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notifications.web.internal.portlet;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.model.UserNotificationEvent;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.service.UserNotificationDeliveryLocalService;
import com.liferay.portal.kernel.service.UserNotificationEventLocalService;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.subscription.service.SubscriptionLocalService;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"com.liferay.portlet.add-default-resource=true", "com.liferay.portlet.css-class-wrapper=notifications-portlet", "com.liferay.portlet.display-category=category.hidden", "com.liferay.portlet.use-default-template=true", "javax.portlet.display-name=Notifications", "javax.portlet.expiration-cache=0", "javax.portlet.init-param.add-process-action-success-action=false", "javax.portlet.init-param.template-path=/", "javax.portlet.init-param.view-template=/notifications/view.jsp", "javax.portlet.name=com_liferay_notifications_web_portlet_NotificationsPortlet", "javax.portlet.resource-bundle=content.Language", "javax.portlet.security-role-ref=administrator,guest,power-user,user", "javax.portlet.supports.mime-type=text/html"}, service={Portlet.class})
public class NotificationsPortlet
extends MVCPortlet {
    @Reference(target="(bundle.symbolic.name=com.liferay.notifications.web)", unbind="-")
    private ResourceBundleLoader _resourceBundleLoader;
    private SubscriptionLocalService _subscriptionLocalService;
    private UserNotificationDeliveryLocalService _userNotificationDeliveryLocalService;
    private UserNotificationEventLocalService _userNotificationEventLocalService;

    public void deleteAllNotifications(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long[] userNotificationEventIds;
        for (long userNotificationEventId : userNotificationEventIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIds")) {
            try {
                this._userNotificationEventLocalService.deleteUserNotificationEvent(userNotificationEventId);
            }
            catch (Exception e) {
                throw new PortletException((Throwable)e);
            }
        }
        this._sendRedirect(actionRequest, actionResponse);
    }

    public void deleteUserNotificationEvent(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long userNotificationEventId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"userNotificationEventId");
        try {
            this._userNotificationEventLocalService.deleteUserNotificationEvent(userNotificationEventId);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        this._sendRedirect(actionRequest, actionResponse);
    }

    public void markAllNotificationsAsRead(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        boolean actionRequired = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"actionRequired");
        this._userNotificationEventLocalService.archiveUserNotificationEvents(themeDisplay.getUserId(), 10002, actionRequired);
        ResourceBundle resourceBundle = this._resourceBundleLoader.loadResourceBundle(themeDisplay.getLocale());
        SessionMessages.add((PortletRequest)actionRequest, (String)"requestProcessed", (Object)LanguageUtil.get((ResourceBundle)resourceBundle, (String)"all-notifications-were-marked-as-read-successfully"));
        this._sendRedirect(actionRequest, actionResponse);
    }

    public void markNotificationAsRead(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long userNotificationEventId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"userNotificationEventId");
        this.updateArchived(userNotificationEventId, true);
        this._sendRedirect(actionRequest, actionResponse);
    }

    public void markNotificationAsUnread(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long userNotificationEventId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"userNotificationEventId");
        this.updateArchived(userNotificationEventId, false);
        this._sendRedirect(actionRequest, actionResponse);
    }

    public void markNotificationsAsRead(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long[] userNotificationEventIds;
        for (long userNotificationEventId : userNotificationEventIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIds")) {
            this.updateArchived(userNotificationEventId, true);
        }
        this._sendRedirect(actionRequest, actionResponse);
    }

    public void markNotificationsAsUnread(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long[] userNotificationEventIds;
        for (long userNotificationEventId : userNotificationEventIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIds")) {
            this.updateArchived(userNotificationEventId, false);
        }
        this._sendRedirect(actionRequest, actionResponse);
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (!themeDisplay.isSignedIn()) {
            return;
        }
        try {
            String actionName = ParamUtil.getString((PortletRequest)actionRequest, (String)"javax.portlet.action");
            if (actionName.equals("deleteAllNotifications")) {
                this.deleteAllNotifications(actionRequest, actionResponse);
            } else if (actionName.equals("deleteUserNotificationEvent")) {
                this.deleteUserNotificationEvent(actionRequest, actionResponse);
            } else if (actionName.equals("markNotificationsAsRead")) {
                this.markNotificationsAsRead(actionRequest, actionResponse);
            } else if (actionName.equals("markNotificationAsRead")) {
                this.markNotificationAsRead(actionRequest, actionResponse);
            } else if (actionName.equals("markNotificationsAsUnread")) {
                this.markNotificationsAsUnread(actionRequest, actionResponse);
            } else if (actionName.equals("markNotificationAsUnread")) {
                this.markNotificationAsUnread(actionRequest, actionResponse);
            } else if (actionName.equals("unsubscribe")) {
                this.unsubscribe(actionRequest, actionResponse);
            } else if (actionName.equals("updateUserNotificationDelivery")) {
                this.updateUserNotificationDelivery(actionRequest, actionResponse);
            } else {
                super.processAction(actionRequest, actionResponse);
            }
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void unsubscribe(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long subscriptionId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"subscriptionId");
        long userNotificationEventId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"userNotificationEventId");
        this._subscriptionLocalService.deleteSubscription(subscriptionId);
        UserNotificationEvent userNotificationEvent = this._userNotificationEventLocalService.fetchUserNotificationEvent(userNotificationEventId);
        if (userNotificationEvent != null && !userNotificationEvent.isArchived()) {
            this.updateArchived(userNotificationEventId, true);
        }
    }

    public void updateUserNotificationDelivery(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long[] userNotificationDeliveryIds;
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        for (long userNotificationDeliveryId : userNotificationDeliveryIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"userNotificationDeliveryIds")) {
            boolean deliver = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)String.valueOf(userNotificationDeliveryId));
            this._userNotificationDeliveryLocalService.updateUserNotificationDelivery(userNotificationDeliveryId, deliver);
        }
        ResourceBundle resourceBundle = this._resourceBundleLoader.loadResourceBundle(themeDisplay.getLocale());
        SessionMessages.add((PortletRequest)actionRequest, (String)"requestProcessed", (Object)LanguageUtil.get((ResourceBundle)resourceBundle, (String)"your-configuration-was-saved-sucessfully"));
        this._sendRedirect(actionRequest, actionResponse);
    }

    @Reference(target="(&(release.bundle.symbolic.name=com.liferay.notifications.web)(release.schema.version=2.1.0))", unbind="-")
    protected void setRelease(Release release) {
    }

    @Reference(unbind="-")
    protected void setSubscriptionLocalService(SubscriptionLocalService subscriptionLocalService) {
        this._subscriptionLocalService = subscriptionLocalService;
    }

    @Reference(unbind="-")
    protected void setUserNotificationDeliveryLocalService(UserNotificationDeliveryLocalService userNotificationDeliveryLocalService) {
        this._userNotificationDeliveryLocalService = userNotificationDeliveryLocalService;
    }

    @Reference(unbind="-")
    protected void setUserNotificationEventLocalService(UserNotificationEventLocalService userNotificationEventLocalService) {
        this._userNotificationEventLocalService = userNotificationEventLocalService;
    }

    protected void updateArchived(long userNotificationEventId, boolean archived) throws Exception {
        UserNotificationEvent userNotificationEvent = this._userNotificationEventLocalService.fetchUserNotificationEvent(userNotificationEventId);
        if (userNotificationEvent == null) {
            return;
        }
        userNotificationEvent.setArchived(archived);
        this._userNotificationEventLocalService.updateUserNotificationEvent(userNotificationEvent);
    }

    private void _sendRedirect(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException {
        String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
        if (Validator.isNotNull((String)redirect)) {
            actionResponse.sendRedirect(redirect);
        }
    }
}

