/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notifications.web.internal.poller;

import com.liferay.portal.kernel.poller.BasePollerProcessor;
import com.liferay.portal.kernel.poller.PollerProcessor;
import com.liferay.portal.kernel.poller.PollerRequest;
import com.liferay.portal.kernel.poller.PollerResponse;
import com.liferay.portal.kernel.service.UserNotificationEventLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_notifications_web_portlet_NotificationsPortlet"}, service={PollerProcessor.class})
public class NotificationsPollerProcessor
extends BasePollerProcessor {
    private UserNotificationEventLocalService _userNotificationEventLocalService;

    protected PollerResponse doReceive(PollerRequest pollerRequest) throws Exception {
        return this.setUserNotificationsCount(pollerRequest);
    }

    protected void doSend(PollerRequest pollerRequest) throws Exception {
    }

    @Reference(unbind="-")
    protected void setUserNotificationEventLocalService(UserNotificationEventLocalService userNotificationEventLocalService) {
        this._userNotificationEventLocalService = userNotificationEventLocalService;
    }

    protected PollerResponse setUserNotificationsCount(PollerRequest pollerRequest) throws Exception {
        PollerResponse pollerResponse = pollerRequest.createPollerResponse();
        pollerResponse.setParameter("timestamp", String.valueOf(System.currentTimeMillis()));
        int newUserNotificationsCount = this._userNotificationEventLocalService.getDeliveredUserNotificationEventsCount(pollerRequest.getUserId(), 10002, false);
        pollerResponse.setParameter("newUserNotificationsCount", String.valueOf(newUserNotificationsCount));
        int unreadUserNotificationsCount = this._userNotificationEventLocalService.getArchivedUserNotificationEventsCount(pollerRequest.getUserId(), 10002, false);
        pollerResponse.setParameter("unreadUserNotificationsCount", String.valueOf(unreadUserNotificationsCount));
        return pollerResponse;
    }
}

