/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notifications.web.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.SafeConsumer;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import java.util.List;
import java.util.Objects;
import javax.portlet.PortletException;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class NotificationsManagementToolbarDisplayContext {
    private final PortletURL _currentURLObj;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;
    private final HttpServletRequest _request;

    public NotificationsManagementToolbarDisplayContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, HttpServletRequest request, PortletURL currentURLObj) {
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
        this._request = request;
        this._currentURLObj = currentURLObj;
    }

    public List<DropdownItem> getActionDropdownItems() {
        final boolean actionRequired = ParamUtil.getBoolean((HttpServletRequest)this._request, (String)"actionRequired");
        return new DropdownItemList(){
            {
                if (!actionRequired) {
                    this.add(SafeConsumer.ignore(dropdownItem -> {
                        dropdownItem.putData("action", "markNotificationsAsRead");
                        dropdownItem.setIcon("envelope-open");
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)NotificationsManagementToolbarDisplayContext.this._request, (String)"mark-as-read"));
                        dropdownItem.setQuickAction(true);
                    }));
                    this.add(SafeConsumer.ignore(dropdownItem -> {
                        dropdownItem.putData("action", "markNotificationsAsUnread");
                        dropdownItem.setIcon("envelope-closed");
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)NotificationsManagementToolbarDisplayContext.this._request, (String)"mark-as-unread"));
                        dropdownItem.setQuickAction(true);
                    }));
                }
                this.add(SafeConsumer.ignore(dropdownItem -> {
                    dropdownItem.putData("action", "deleteAllNotifications");
                    dropdownItem.setIcon("times");
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)NotificationsManagementToolbarDisplayContext.this._request, (String)"delete"));
                    dropdownItem.setQuickAction(true);
                }));
            }
        };
    }

    public List<DropdownItem> getFilterDropdownItems() {
        return new DropdownItemList(){
            {
                this.addGroup(SafeConsumer.ignore(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(NotificationsManagementToolbarDisplayContext.this._getFilterNavigationDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)NotificationsManagementToolbarDisplayContext.this._request, (String)"filter-by-navigation"));
                }));
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(NotificationsManagementToolbarDisplayContext.this._getOrderByDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)NotificationsManagementToolbarDisplayContext.this._request, (String)"order-by"));
                });
            }
        };
    }

    public String getOrderByType() {
        return ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByType", (String)"desc");
    }

    public PortletURL getSortingURL() throws PortletException {
        PortletURL sortingURL = PortletURLUtil.clone((PortletURL)this._currentURLObj, (LiferayPortletResponse)this._liferayPortletResponse);
        sortingURL.setParameter("cur", "0");
        sortingURL.setParameter("orderByCol", "date");
        sortingURL.setParameter("orderByType", Objects.equals(this.getOrderByType(), "asc") ? "desc" : "asc");
        return sortingURL;
    }

    private List<DropdownItem> _getFilterNavigationDropdownItems() {
        final String navigation = ParamUtil.getString((HttpServletRequest)this._request, (String)"navigation", (String)"all");
        return new DropdownItemList(){
            {
                this.add(SafeConsumer.ignore(dropdownItem -> {
                    dropdownItem.setHref(PortletURLUtil.clone((PortletURL)NotificationsManagementToolbarDisplayContext.this._currentURLObj, (LiferayPortletResponse)NotificationsManagementToolbarDisplayContext.this._liferayPortletResponse), new Object[]{"cur", "0", "navigation", "all"});
                    dropdownItem.setActive(navigation.equals("all"));
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)NotificationsManagementToolbarDisplayContext.this._request, (String)"all"));
                }));
                this.add(SafeConsumer.ignore(dropdownItem -> {
                    dropdownItem.setHref(PortletURLUtil.clone((PortletURL)NotificationsManagementToolbarDisplayContext.this._currentURLObj, (LiferayPortletResponse)NotificationsManagementToolbarDisplayContext.this._liferayPortletResponse), new Object[]{"cur", "0", "navigation", "unread"});
                    dropdownItem.setActive(navigation.equals("unread"));
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)NotificationsManagementToolbarDisplayContext.this._request, (String)"unread"));
                }));
                this.add(SafeConsumer.ignore(dropdownItem -> {
                    dropdownItem.setHref(PortletURLUtil.clone((PortletURL)NotificationsManagementToolbarDisplayContext.this._currentURLObj, (LiferayPortletResponse)NotificationsManagementToolbarDisplayContext.this._liferayPortletResponse), new Object[]{"cur", "0", "navigation", "read"});
                    dropdownItem.setActive(navigation.equals("read"));
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)NotificationsManagementToolbarDisplayContext.this._request, (String)"read"));
                }));
            }
        };
    }

    private List<DropdownItem> _getOrderByDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(SafeConsumer.ignore(dropdownItem -> {
                    dropdownItem.setActive(true);
                    dropdownItem.setHref((Object)NotificationsManagementToolbarDisplayContext.this.getSortingURL());
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)NotificationsManagementToolbarDisplayContext.this._request, (String)"date"));
                }));
            }
        };
    }
}

