/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.notification.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.notification.model.NotificationTemplateAttachment;
import com.liferay.notification.model.NotificationTemplateAttachmentModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the NotificationTemplateAttachment service. Represents a row in the &quot;NTemplateAttachment&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>NotificationTemplateAttachmentModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link NotificationTemplateAttachmentImpl}.
 * </p>
 *
 * @author Gabriel Albuquerque
 * @see NotificationTemplateAttachmentImpl
 * @generated
 */
public class NotificationTemplateAttachmentModelImpl
	extends BaseModelImpl<NotificationTemplateAttachment>
	implements NotificationTemplateAttachmentModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a notification template attachment model instance should use the <code>NotificationTemplateAttachment</code> interface instead.
	 */
	public static final String TABLE_NAME = "NTemplateAttachment";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"NTemplateAttachmentId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"notificationTemplateId", Types.BIGINT},
		{"objectFieldId", Types.BIGINT}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("NTemplateAttachmentId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("notificationTemplateId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("objectFieldId", Types.BIGINT);
	}

	public static final String TABLE_SQL_CREATE =
		"create table NTemplateAttachment (mvccVersion LONG default 0 not null,NTemplateAttachmentId LONG not null primary key,companyId LONG,notificationTemplateId LONG,objectFieldId LONG)";

	public static final String TABLE_SQL_DROP =
		"drop table NTemplateAttachment";

	public static final String ORDER_BY_JPQL =
		" ORDER BY notificationTemplateAttachment.notificationTemplateAttachmentId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY NTemplateAttachment.NTemplateAttachmentId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long NOTIFICATIONTEMPLATEID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTFIELDID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long NOTIFICATIONTEMPLATEATTACHMENTID_COLUMN_BITMASK =
		4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public NotificationTemplateAttachmentModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _notificationTemplateAttachmentId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setNotificationTemplateAttachmentId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _notificationTemplateAttachmentId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return NotificationTemplateAttachment.class;
	}

	@Override
	public String getModelClassName() {
		return NotificationTemplateAttachment.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<NotificationTemplateAttachment, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<NotificationTemplateAttachment, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<NotificationTemplateAttachment, Object>
				attributeGetterFunction = entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply(
					(NotificationTemplateAttachment)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<NotificationTemplateAttachment, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<NotificationTemplateAttachment, Object>
				attributeSetterBiConsumer = attributeSetterBiConsumers.get(
					attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(NotificationTemplateAttachment)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<NotificationTemplateAttachment, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<NotificationTemplateAttachment, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map
		<String, Function<NotificationTemplateAttachment, Object>>
			_attributeGetterFunctions;
	private static final Map
		<String, BiConsumer<NotificationTemplateAttachment, Object>>
			_attributeSetterBiConsumers;

	static {
		Map<String, Function<NotificationTemplateAttachment, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String,
					 Function<NotificationTemplateAttachment, Object>>();
		Map<String, BiConsumer<NotificationTemplateAttachment, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap
					<String, BiConsumer<NotificationTemplateAttachment, ?>>();

		attributeGetterFunctions.put(
			"mvccVersion", NotificationTemplateAttachment::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<NotificationTemplateAttachment, Long>)
				NotificationTemplateAttachment::setMvccVersion);
		attributeGetterFunctions.put(
			"notificationTemplateAttachmentId",
			NotificationTemplateAttachment::
				getNotificationTemplateAttachmentId);
		attributeSetterBiConsumers.put(
			"notificationTemplateAttachmentId",
			(BiConsumer<NotificationTemplateAttachment, Long>)
				NotificationTemplateAttachment::
					setNotificationTemplateAttachmentId);
		attributeGetterFunctions.put(
			"companyId", NotificationTemplateAttachment::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<NotificationTemplateAttachment, Long>)
				NotificationTemplateAttachment::setCompanyId);
		attributeGetterFunctions.put(
			"notificationTemplateId",
			NotificationTemplateAttachment::getNotificationTemplateId);
		attributeSetterBiConsumers.put(
			"notificationTemplateId",
			(BiConsumer<NotificationTemplateAttachment, Long>)
				NotificationTemplateAttachment::setNotificationTemplateId);
		attributeGetterFunctions.put(
			"objectFieldId", NotificationTemplateAttachment::getObjectFieldId);
		attributeSetterBiConsumers.put(
			"objectFieldId",
			(BiConsumer<NotificationTemplateAttachment, Long>)
				NotificationTemplateAttachment::setObjectFieldId);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@Override
	public long getNotificationTemplateAttachmentId() {
		return _notificationTemplateAttachmentId;
	}

	@Override
	public void setNotificationTemplateAttachmentId(
		long notificationTemplateAttachmentId) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_notificationTemplateAttachmentId = notificationTemplateAttachmentId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	@Override
	public long getNotificationTemplateId() {
		return _notificationTemplateId;
	}

	@Override
	public void setNotificationTemplateId(long notificationTemplateId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_notificationTemplateId = notificationTemplateId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalNotificationTemplateId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("notificationTemplateId"));
	}

	@Override
	public long getObjectFieldId() {
		return _objectFieldId;
	}

	@Override
	public void setObjectFieldId(long objectFieldId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectFieldId = objectFieldId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalObjectFieldId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("objectFieldId"));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), NotificationTemplateAttachment.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public NotificationTemplateAttachment toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, NotificationTemplateAttachment>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		NotificationTemplateAttachmentImpl notificationTemplateAttachmentImpl =
			new NotificationTemplateAttachmentImpl();

		notificationTemplateAttachmentImpl.setMvccVersion(getMvccVersion());
		notificationTemplateAttachmentImpl.setNotificationTemplateAttachmentId(
			getNotificationTemplateAttachmentId());
		notificationTemplateAttachmentImpl.setCompanyId(getCompanyId());
		notificationTemplateAttachmentImpl.setNotificationTemplateId(
			getNotificationTemplateId());
		notificationTemplateAttachmentImpl.setObjectFieldId(getObjectFieldId());

		notificationTemplateAttachmentImpl.resetOriginalValues();

		return notificationTemplateAttachmentImpl;
	}

	@Override
	public NotificationTemplateAttachment cloneWithOriginalValues() {
		NotificationTemplateAttachmentImpl notificationTemplateAttachmentImpl =
			new NotificationTemplateAttachmentImpl();

		notificationTemplateAttachmentImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		notificationTemplateAttachmentImpl.setNotificationTemplateAttachmentId(
			this.<Long>getColumnOriginalValue("NTemplateAttachmentId"));
		notificationTemplateAttachmentImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		notificationTemplateAttachmentImpl.setNotificationTemplateId(
			this.<Long>getColumnOriginalValue("notificationTemplateId"));
		notificationTemplateAttachmentImpl.setObjectFieldId(
			this.<Long>getColumnOriginalValue("objectFieldId"));

		return notificationTemplateAttachmentImpl;
	}

	@Override
	public int compareTo(
		NotificationTemplateAttachment notificationTemplateAttachment) {

		long primaryKey = notificationTemplateAttachment.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof NotificationTemplateAttachment)) {
			return false;
		}

		NotificationTemplateAttachment notificationTemplateAttachment =
			(NotificationTemplateAttachment)object;

		long primaryKey = notificationTemplateAttachment.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<NotificationTemplateAttachment> toCacheModel() {
		NotificationTemplateAttachmentCacheModel
			notificationTemplateAttachmentCacheModel =
				new NotificationTemplateAttachmentCacheModel();

		notificationTemplateAttachmentCacheModel.mvccVersion = getMvccVersion();

		notificationTemplateAttachmentCacheModel.
			notificationTemplateAttachmentId =
				getNotificationTemplateAttachmentId();

		notificationTemplateAttachmentCacheModel.companyId = getCompanyId();

		notificationTemplateAttachmentCacheModel.notificationTemplateId =
			getNotificationTemplateId();

		notificationTemplateAttachmentCacheModel.objectFieldId =
			getObjectFieldId();

		return notificationTemplateAttachmentCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<NotificationTemplateAttachment, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<NotificationTemplateAttachment, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<NotificationTemplateAttachment, Object>
				attributeGetterFunction = entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(NotificationTemplateAttachment)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function
			<InvocationHandler, NotificationTemplateAttachment>
				_escapedModelProxyProviderFunction =
					ProxyUtil.getProxyProviderFunction(
						NotificationTemplateAttachment.class,
						ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _notificationTemplateAttachmentId;
	private long _companyId;
	private long _notificationTemplateId;
	private long _objectFieldId;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<NotificationTemplateAttachment, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((NotificationTemplateAttachment)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put(
			"NTemplateAttachmentId", _notificationTemplateAttachmentId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put(
			"notificationTemplateId", _notificationTemplateId);
		_columnOriginalValues.put("objectFieldId", _objectFieldId);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put(
			"NTemplateAttachmentId", "notificationTemplateAttachmentId");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("NTemplateAttachmentId", 2L);

		columnBitmasks.put("companyId", 4L);

		columnBitmasks.put("notificationTemplateId", 8L);

		columnBitmasks.put("objectFieldId", 16L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private NotificationTemplateAttachment _escapedModel;

}