/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.notification.model.impl;

import com.liferay.notification.model.NotificationQueueEntryAttachment;
import com.liferay.notification.service.NotificationQueueEntryAttachmentLocalServiceUtil;

/**
 * The extended model base implementation for the NotificationQueueEntryAttachment service. Represents a row in the &quot;NQueueEntryAttachment&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link NotificationQueueEntryAttachmentImpl}.
 * </p>
 *
 * @author Gabriel Albuquerque
 * @see NotificationQueueEntryAttachmentImpl
 * @see NotificationQueueEntryAttachment
 * @generated
 */
public abstract class NotificationQueueEntryAttachmentBaseImpl
	extends NotificationQueueEntryAttachmentModelImpl
	implements NotificationQueueEntryAttachment {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a notification queue entry attachment model instance should use the <code>NotificationQueueEntryAttachment</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			NotificationQueueEntryAttachmentLocalServiceUtil.
				addNotificationQueueEntryAttachment(this);
		}
		else {
			NotificationQueueEntryAttachmentLocalServiceUtil.
				updateNotificationQueueEntryAttachment(this);
		}
	}

}