/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.notification.internal.search.spi.model.index.contributor;

import com.liferay.notification.model.NotificationQueueEntry;
import com.liferay.notification.model.NotificationRecipient;
import com.liferay.notification.util.NotificationRecipientSettingUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;

import java.util.Map;

import org.osgi.service.component.annotations.Component;

/**
 * @author Paulo Albuquerque
 */
@Component(
	property = "indexer.class.name=com.liferay.notification.model.NotificationQueueEntry",
	service = ModelDocumentContributor.class
)
public class NotificationQueueEntryModelDocumentContributor
	implements ModelDocumentContributor<NotificationQueueEntry> {

	@Override
	public void contribute(
		Document document, NotificationQueueEntry notificationQueueEntry) {

		NotificationRecipient notificationRecipient =
			notificationQueueEntry.getNotificationRecipient();

		Map<String, Object> notificationRecipientSettingsMap =
			NotificationRecipientSettingUtil.toMap(
				notificationRecipient.getNotificationRecipientSettings());

		document.addKeyword(
			"fromName",
			String.valueOf(notificationRecipientSettingsMap.get("fromName")));
		document.addText(
			"fromName",
			String.valueOf(notificationRecipientSettingsMap.get("from")));

		document.addKeyword("subject", notificationQueueEntry.getSubject());
		document.addText("subject", notificationQueueEntry.getSubject());

		String toName = String.valueOf(
			notificationRecipientSettingsMap.get("fromName"));

		document.addKeyword("toName", toName);
		document.addText("toName", toName);
		document.addKeyword("triggerBy", toName);
		document.addText("triggerBy", toName);
	}

}