/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notification.rest.internal.resource.v1_0;

import com.liferay.notification.context.NotificationContext;
import com.liferay.notification.model.NotificationRecipient;
import com.liferay.notification.model.NotificationRecipientSetting;
import com.liferay.notification.model.NotificationTemplateAttachmentModel;
import com.liferay.notification.rest.dto.v1_0.NotificationTemplate;
import com.liferay.notification.rest.dto.v1_0.util.NotificationUtil;
import com.liferay.notification.rest.internal.odata.entity.v1_0.NotificationTemplateEntityModel;
import com.liferay.notification.rest.internal.resource.v1_0.BaseNotificationTemplateResourceImpl;
import com.liferay.notification.rest.resource.v1_0.NotificationTemplateResource;
import com.liferay.notification.service.NotificationTemplateAttachmentLocalService;
import com.liferay.notification.service.NotificationTemplateService;
import com.liferay.notification.type.NotificationType;
import com.liferay.notification.type.NotificationTypeServiceTracker;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/notification-template.properties"}, scope=ServiceScope.PROTOTYPE, service={NotificationTemplateResource.class})
public class NotificationTemplateResourceImpl
extends BaseNotificationTemplateResourceImpl {
    private static final EntityModel _entityModel = new NotificationTemplateEntityModel();
    @Reference
    private Language _language;
    @Reference
    private NotificationTemplateAttachmentLocalService _notificationTemplateAttachmentLocalService;
    @Reference
    private NotificationTemplateService _notificationTemplateService;
    @Reference
    private NotificationTypeServiceTracker _notificationTypeServiceTracker;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;

    @Override
    public void deleteNotificationTemplate(Long notificationTemplateId) throws Exception {
        this._notificationTemplateService.deleteNotificationTemplate(notificationTemplateId.longValue());
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return _entityModel;
    }

    @Override
    public NotificationTemplate getNotificationTemplate(Long notificationTemplateId) throws Exception {
        return this._toNotificationTemplate(this._notificationTemplateService.getNotificationTemplate(notificationTemplateId.longValue()));
    }

    @Override
    public NotificationTemplate getNotificationTemplateByExternalReferenceCode(String externalReferenceCode) throws Exception {
        return this._toNotificationTemplate(this._notificationTemplateService.fetchNotificationTemplateByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId()));
    }

    @Override
    public Page<NotificationTemplate> getNotificationTemplatesPage(String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search((Map)HashMapBuilder.put((Object)"create", this.addAction("ADD_NOTIFICATION_TEMPLATE", "postNotificationTemplate", "com.liferay.notification.template", this.contextCompany.getCompanyId())).put((Object)"get", this.addAction("VIEW", "getNotificationTemplatesPage", "com.liferay.notification.template", this.contextCompany.getCompanyId())).build(), booleanQuery -> {}, (Filter)filter, (String)com.liferay.notification.model.NotificationTemplate.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.setAttribute("name", (Serializable)((Object)search));
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
        }, (Sort[])sorts, document -> this._toNotificationTemplate(this._notificationTemplateService.getNotificationTemplate(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    @Override
    public NotificationTemplate postNotificationTemplate(NotificationTemplate notificationTemplate) throws Exception {
        NotificationContext notificationContext = NotificationUtil.toNotificationContext((NotificationTemplate)notificationTemplate, (ObjectFieldLocalService)this._objectFieldLocalService);
        notificationContext.setNotificationRecipient(NotificationUtil.toNotificationRecipient((User)this.contextUser, (long)0L));
        notificationContext.setNotificationRecipientSettings(NotificationUtil.toNotificationRecipientSetting((long)0L, (NotificationType)this._notificationTypeServiceTracker.getNotificationType(notificationTemplate.getType()), (Object[])notificationTemplate.getRecipients(), (User)this.contextUser));
        notificationContext.setNotificationTemplate(NotificationUtil.toNotificationTemplate((long)0L, (NotificationTemplate)notificationTemplate, (ObjectDefinitionLocalService)this._objectDefinitionLocalService, (User)this.contextUser));
        return this._toNotificationTemplate(this._notificationTemplateService.addNotificationTemplate(notificationContext));
    }

    @Override
    public NotificationTemplate postNotificationTemplateCopy(Long notificationTemplateId) throws Exception {
        NotificationContext notificationContext = new NotificationContext();
        com.liferay.notification.model.NotificationTemplate notificationTemplate = this._notificationTemplateService.getNotificationTemplate(notificationTemplateId.longValue());
        notificationTemplate.setUuid(null);
        notificationTemplate.setExternalReferenceCode(null);
        notificationTemplate.setUserId(this.contextUser.getUserId());
        notificationTemplate.setUserName(this.contextUser.getFullName());
        Date date = new Date();
        notificationTemplate.setCreateDate(date);
        notificationTemplate.setModifiedDate(date);
        notificationTemplate.setName(StringUtil.appendParentheticalSuffix((String)notificationTemplate.getName(), (String)"copy"));
        NotificationRecipient notificationRecipient = notificationTemplate.getNotificationRecipient();
        notificationRecipient.setUuid(null);
        notificationRecipient.setUserId(this.contextUser.getUserId());
        notificationRecipient.setUserName(this.contextUser.getFullName());
        notificationRecipient.setCreateDate(date);
        notificationRecipient.setModifiedDate(date);
        notificationContext.setNotificationRecipient(notificationRecipient);
        ArrayList<NotificationRecipientSetting> notificationRecipientSettings = new ArrayList<NotificationRecipientSetting>();
        for (NotificationRecipientSetting notificationRecipientSetting : notificationRecipient.getNotificationRecipientSettings()) {
            notificationRecipientSetting.setUuid(null);
            notificationRecipientSetting.setUserId(this.contextUser.getUserId());
            notificationRecipientSetting.setUserName(this.contextUser.getFullName());
            notificationRecipientSetting.setCreateDate(date);
            notificationRecipientSetting.setModifiedDate(date);
            notificationRecipientSettings.add(notificationRecipientSetting);
        }
        notificationContext.setNotificationRecipientSettings(notificationRecipientSettings);
        notificationContext.setNotificationTemplate(notificationTemplate);
        notificationContext.setType(notificationTemplate.getType());
        return this._toNotificationTemplate(this._notificationTemplateService.addNotificationTemplate(notificationContext));
    }

    @Override
    public NotificationTemplate putNotificationTemplate(Long notificationTemplateId, NotificationTemplate notificationTemplate) throws Exception {
        NotificationContext notificationContext = NotificationUtil.toNotificationContext((NotificationTemplate)notificationTemplate, (ObjectFieldLocalService)this._objectFieldLocalService);
        NotificationRecipient notificationRecipient = NotificationUtil.toNotificationRecipient((User)this.contextUser, (long)notificationTemplateId);
        notificationContext.setNotificationRecipient(notificationRecipient);
        notificationContext.setNotificationRecipientSettings(NotificationUtil.toNotificationRecipientSetting((long)notificationRecipient.getNotificationRecipientId(), (NotificationType)this._notificationTypeServiceTracker.getNotificationType(notificationTemplate.getType()), (Object[])notificationTemplate.getRecipients(), (User)this.contextUser));
        notificationContext.setNotificationTemplate(NotificationUtil.toNotificationTemplate((long)notificationTemplateId, (NotificationTemplate)notificationTemplate, (ObjectDefinitionLocalService)this._objectDefinitionLocalService, (User)this.contextUser));
        return this._toNotificationTemplate(this._notificationTemplateService.updateNotificationTemplate(notificationContext));
    }

    @Override
    public NotificationTemplate putNotificationTemplateByExternalReferenceCode(String externalReferenceCode, NotificationTemplate notificationTemplate) throws Exception {
        notificationTemplate.setExternalReferenceCode(() -> externalReferenceCode);
        com.liferay.notification.model.NotificationTemplate serviceBuilderNotificationTemplate = this._notificationTemplateService.fetchNotificationTemplateByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (serviceBuilderNotificationTemplate != null) {
            return this.putNotificationTemplate(serviceBuilderNotificationTemplate.getNotificationTemplateId(), notificationTemplate);
        }
        return this.postNotificationTemplate(notificationTemplate);
    }

    private Locale _getLocale() {
        if (this.contextUser != null) {
            return this.contextUser.getLocale();
        }
        return this.contextAcceptLanguage.getPreferredLocale();
    }

    private NotificationTemplate _toNotificationTemplate(final com.liferay.notification.model.NotificationTemplate serviceBuilderNotificationTemplate) {
        if (serviceBuilderNotificationTemplate == null) {
            return null;
        }
        final NotificationType notificationType = this._notificationTypeServiceTracker.getNotificationType(serviceBuilderNotificationTemplate.getType());
        return new NotificationTemplate(){
            {
                this.setActions(() -> HashMapBuilder.put((Object)"copy", NotificationTemplateResourceImpl.this.addAction("UPDATE", "postNotificationTemplateCopy", com.liferay.notification.model.NotificationTemplate.class.getName(), serviceBuilderNotificationTemplate.getNotificationTemplateId())).put((Object)"delete", () -> {
                    if (serviceBuilderNotificationTemplate.isSystem()) {
                        return null;
                    }
                    return NotificationTemplateResourceImpl.this.addAction("DELETE", "deleteNotificationTemplate", com.liferay.notification.model.NotificationTemplate.class.getName(), serviceBuilderNotificationTemplate.getNotificationTemplateId());
                }).put((Object)"get", NotificationTemplateResourceImpl.this.addAction("VIEW", "getNotificationTemplate", com.liferay.notification.model.NotificationTemplate.class.getName(), serviceBuilderNotificationTemplate.getNotificationTemplateId())).put((Object)"permissions", NotificationTemplateResourceImpl.this.addAction("PERMISSIONS", "patchNotificationTemplate", com.liferay.notification.model.NotificationTemplate.class.getName(), serviceBuilderNotificationTemplate.getNotificationTemplateId())).put((Object)"update", NotificationTemplateResourceImpl.this.addAction("UPDATE", "putNotificationTemplate", com.liferay.notification.model.NotificationTemplate.class.getName(), serviceBuilderNotificationTemplate.getNotificationTemplateId())).build());
                this.setAttachmentObjectFieldExternalReferenceCodes(() -> NotificationTemplateResourceImpl.this.transformToArray(NotificationTemplateResourceImpl.this._notificationTemplateAttachmentLocalService.getNotificationTemplateAttachments(serviceBuilderNotificationTemplate.getNotificationTemplateId()), notificationTemplateAttachment -> {
                    ObjectField objectField = NotificationTemplateResourceImpl.this._objectFieldLocalService.fetchObjectField(notificationTemplateAttachment.getObjectFieldId());
                    if (objectField == null) {
                        return null;
                    }
                    return objectField.getExternalReferenceCode();
                }, String.class));
                this.setAttachmentObjectFieldIds(() -> NotificationTemplateResourceImpl.this.transformToArray(NotificationTemplateResourceImpl.this._notificationTemplateAttachmentLocalService.getNotificationTemplateAttachments(serviceBuilderNotificationTemplate.getNotificationTemplateId()), NotificationTemplateAttachmentModel::getObjectFieldId, Long.class));
                this.setBody(() -> LocalizedMapUtil.getLanguageIdMap((Map)serviceBuilderNotificationTemplate.getBodyMap()));
                this.setDateCreated(() -> ((com.liferay.notification.model.NotificationTemplate)serviceBuilderNotificationTemplate).getCreateDate());
                this.setDateModified(() -> ((com.liferay.notification.model.NotificationTemplate)serviceBuilderNotificationTemplate).getModifiedDate());
                this.setDescription(() -> ((com.liferay.notification.model.NotificationTemplate)serviceBuilderNotificationTemplate).getDescription());
                this.setEditorType(() -> NotificationTemplate.EditorType.create((String)serviceBuilderNotificationTemplate.getEditorType()));
                this.setExternalReferenceCode(() -> ((com.liferay.notification.model.NotificationTemplate)serviceBuilderNotificationTemplate).getExternalReferenceCode());
                this.setId(() -> ((com.liferay.notification.model.NotificationTemplate)serviceBuilderNotificationTemplate).getNotificationTemplateId());
                this.setName(() -> ((com.liferay.notification.model.NotificationTemplate)serviceBuilderNotificationTemplate).getName());
                this.setName_i18n(() -> LocalizedMapUtil.getLanguageIdMap((Map)serviceBuilderNotificationTemplate.getNameMap()));
                this.setObjectDefinitionExternalReferenceCode(() -> {
                    ObjectDefinition objectDefinition = NotificationTemplateResourceImpl.this._objectDefinitionLocalService.fetchObjectDefinition(GetterUtil.getLong((Object)serviceBuilderNotificationTemplate.getObjectDefinitionId()));
                    if (objectDefinition == null) {
                        return "";
                    }
                    return objectDefinition.getExternalReferenceCode();
                });
                this.setObjectDefinitionId(() -> ((com.liferay.notification.model.NotificationTemplate)serviceBuilderNotificationTemplate).getObjectDefinitionId());
                this.setRecipients(() -> {
                    NotificationRecipient notificationRecipient = serviceBuilderNotificationTemplate.getNotificationRecipient();
                    return notificationType.toRecipients(notificationRecipient.getNotificationRecipientSettings());
                });
                this.setRecipientType(() -> ((com.liferay.notification.model.NotificationTemplate)serviceBuilderNotificationTemplate).getRecipientType());
                this.setSubject(() -> LocalizedMapUtil.getLanguageIdMap((Map)serviceBuilderNotificationTemplate.getSubjectMap()));
                this.setSystem(() -> ((com.liferay.notification.model.NotificationTemplate)serviceBuilderNotificationTemplate).isSystem());
                this.setType(() -> ((com.liferay.notification.model.NotificationTemplate)serviceBuilderNotificationTemplate).getType());
                this.setTypeLabel(() -> NotificationTemplateResourceImpl.this._language.get(NotificationTemplateResourceImpl.this._getLocale(), notificationType.getTypeLanguageKey()));
            }
        };
    }
}

