/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notification.rest.internal.resource.v1_0;

import com.liferay.notification.context.NotificationContext;
import com.liferay.notification.exception.NotificationQueueEntryTypeException;
import com.liferay.notification.handler.NotificationHandler;
import com.liferay.notification.handler.NotificationHandlerTracker;
import com.liferay.notification.model.NotificationRecipient;
import com.liferay.notification.rest.dto.v1_0.NotificationQueueEntry;
import com.liferay.notification.rest.dto.v1_0.util.NotificationUtil;
import com.liferay.notification.rest.internal.resource.v1_0.BaseNotificationQueueEntryResourceImpl;
import com.liferay.notification.rest.resource.v1_0.NotificationQueueEntryResource;
import com.liferay.notification.service.NotificationQueueEntryService;
import com.liferay.notification.type.NotificationType;
import com.liferay.notification.type.NotificationTypeServiceTracker;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/notification-queue-entry.properties"}, scope=ServiceScope.PROTOTYPE, service={NotificationQueueEntryResource.class})
public class NotificationQueueEntryResourceImpl
extends BaseNotificationQueueEntryResourceImpl {
    @Reference
    private Language _language;
    @Reference
    private NotificationHandlerTracker _notificationHandlerTracker;
    @Reference
    private NotificationQueueEntryService _notificationQueueEntryService;
    @Reference
    private NotificationTypeServiceTracker _notificationTypeServiceTracker;
    @Reference
    private Portal _portal;

    @Override
    public void deleteNotificationQueueEntry(Long notificationQueueEntryId) throws Exception {
        this._notificationQueueEntryService.deleteNotificationQueueEntry(notificationQueueEntryId.longValue());
    }

    @Override
    public Page<NotificationQueueEntry> getNotificationQueueEntriesPage(String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search((Map)HashMapBuilder.put((Object)"create", this.addAction("ADD_NOTIFICATION_QUEUE_ENTRY", "postNotificationQueueEntry", "com.liferay.notification.queue", this.contextCompany.getCompanyId())).put((Object)"get", this.addAction("VIEW", "getNotificationQueueEntriesPage", "com.liferay.notification.queue", this.contextCompany.getCompanyId())).build(), booleanQuery -> {}, (Filter)filter, (String)com.liferay.notification.model.NotificationQueueEntry.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> searchContext.setCompanyId(this.contextCompany.getCompanyId()), (Sort[])sorts, document -> this._toNotificationQueueEntry(this._notificationQueueEntryService.getNotificationQueueEntry(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    @Override
    public NotificationQueueEntry getNotificationQueueEntry(Long notificationQueueEntryId) throws Exception {
        return this._toNotificationQueueEntry(this._notificationQueueEntryService.getNotificationQueueEntry(notificationQueueEntryId.longValue()));
    }

    @Override
    public NotificationQueueEntry postNotificationQueueEntry(NotificationQueueEntry notificationQueueEntry) throws Exception {
        if (!StringUtil.equals((String)notificationQueueEntry.getType(), (String)"email")) {
            throw new NotificationQueueEntryTypeException("Type can only be email");
        }
        NotificationContext notificationContext = new NotificationContext();
        NotificationType notificationType = this._notificationTypeServiceTracker.getNotificationType("email");
        notificationContext.setNotificationQueueEntry(notificationType.createNotificationQueueEntry(this.contextUser, notificationQueueEntry.getBody(), notificationContext, notificationQueueEntry.getSubject()));
        notificationContext.setNotificationRecipient(NotificationUtil.toNotificationRecipient((User)this.contextUser, (long)0L));
        for (Object recipient : notificationQueueEntry.getRecipients()) {
            Map recipientMap = (Map)recipient;
            recipientMap.putAll(notificationType.evaluateNotificationRecipientSettings(this.contextCompany.getCompanyId(), notificationContext, recipientMap));
        }
        notificationContext.setNotificationRecipientSettings(NotificationUtil.toNotificationRecipientSetting((long)0L, (NotificationType)notificationType, (Object[])notificationQueueEntry.getRecipients(), (User)this.contextUser));
        notificationContext.setType("email");
        com.liferay.notification.model.NotificationQueueEntry serviceBuilderNotificationQueueEntry = this._notificationQueueEntryService.addNotificationQueueEntry(notificationContext);
        notificationType.sendNotification(serviceBuilderNotificationQueueEntry);
        return this._toNotificationQueueEntry(serviceBuilderNotificationQueueEntry);
    }

    @Override
    public void putNotificationQueueEntryResend(Long notificationQueueEntryId) throws Exception {
        this._notificationQueueEntryService.resendNotificationQueueEntry(notificationQueueEntryId.longValue());
    }

    private Locale _getLocale() {
        if (this.contextUser != null) {
            return this.contextUser.getLocale();
        }
        return this.contextAcceptLanguage.getPreferredLocale();
    }

    private NotificationQueueEntry _toNotificationQueueEntry(final com.liferay.notification.model.NotificationQueueEntry serviceBuilderNotificationQueueEntry) throws PortalException {
        final NotificationType notificationType = this._notificationTypeServiceTracker.getNotificationType(serviceBuilderNotificationQueueEntry.getType());
        return new NotificationQueueEntry(){
            {
                this.setActions(() -> HashMapBuilder.put((Object)"delete", NotificationQueueEntryResourceImpl.this.addAction("DELETE", "deleteNotificationQueueEntry", com.liferay.notification.model.NotificationQueueEntry.class.getName(), serviceBuilderNotificationQueueEntry.getNotificationQueueEntryId())).put((Object)"get", NotificationQueueEntryResourceImpl.this.addAction("VIEW", "getNotificationQueueEntry", com.liferay.notification.model.NotificationQueueEntry.class.getName(), serviceBuilderNotificationQueueEntry.getNotificationQueueEntryId())).put((Object)"update", () -> {
                    int status = serviceBuilderNotificationQueueEntry.getStatus();
                    if (status == 1) {
                        return null;
                    }
                    return NotificationQueueEntryResourceImpl.this.addAction("UPDATE", "putNotificationQueueEntryResend", com.liferay.notification.model.NotificationQueueEntry.class.getName(), serviceBuilderNotificationQueueEntry.getNotificationQueueEntryId());
                }).build());
                this.setBody(() -> ((com.liferay.notification.model.NotificationQueueEntry)serviceBuilderNotificationQueueEntry).getBody());
                this.setFromName(() -> notificationType.getFromName(serviceBuilderNotificationQueueEntry));
                this.setId(() -> serviceBuilderNotificationQueueEntry.getNotificationQueueEntryId());
                this.setRecipients(() -> {
                    NotificationRecipient notificationRecipient = serviceBuilderNotificationQueueEntry.getNotificationRecipient();
                    return notificationType.toRecipients(notificationRecipient.getNotificationRecipientSettings());
                });
                this.setRecipientsSummary(() -> notificationType.getRecipientSummary(serviceBuilderNotificationQueueEntry));
                this.setSentDate(() -> ((com.liferay.notification.model.NotificationQueueEntry)serviceBuilderNotificationQueueEntry).getSentDate());
                this.setStatus(() -> ((com.liferay.notification.model.NotificationQueueEntry)serviceBuilderNotificationQueueEntry).getStatus());
                this.setSubject(() -> ((com.liferay.notification.model.NotificationQueueEntry)serviceBuilderNotificationQueueEntry).getSubject());
                this.setTriggerBy(() -> {
                    long classNameId = serviceBuilderNotificationQueueEntry.getClassNameId();
                    if (classNameId == 0L) {
                        return NotificationQueueEntryResourceImpl.this._language.get(NotificationQueueEntryResourceImpl.this.contextAcceptLanguage.getPreferredLocale(), "added-via-api");
                    }
                    NotificationHandler notificationHandler = NotificationQueueEntryResourceImpl.this._notificationHandlerTracker.getNotificationHandler(NotificationQueueEntryResourceImpl.this._portal.getClassName(classNameId));
                    if (notificationHandler != null) {
                        return notificationHandler.getTriggerBy(NotificationQueueEntryResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                    }
                    return NotificationQueueEntryResourceImpl.this._language.get(NotificationQueueEntryResourceImpl.this.contextAcceptLanguage.getPreferredLocale(), "missing-object-definition");
                });
                this.setType(() -> ((com.liferay.notification.model.NotificationQueueEntry)serviceBuilderNotificationQueueEntry).getType());
                this.setTypeLabel(() -> NotificationQueueEntryResourceImpl.this._language.get(NotificationQueueEntryResourceImpl.this._getLocale(), notificationType.getTypeLanguageKey()));
            }
        };
    }
}

