/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notification.util;

import com.liferay.notification.constants.NotificationRecipientSettingConstants;
import com.liferay.notification.model.NotificationQueueEntry;
import com.liferay.notification.model.NotificationRecipient;
import com.liferay.notification.model.NotificationRecipientSetting;
import com.liferay.notification.service.NotificationRecipientSettingLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class NotificationRecipientSettingUtil {
    public static NotificationRecipientSetting createNotificationRecipientSetting(String name, Object value) {
        NotificationRecipientSetting notificationRecipientSetting = NotificationRecipientSettingLocalServiceUtil.createNotificationRecipientSetting(0L);
        notificationRecipientSetting.setName(name);
        if (value instanceof String) {
            notificationRecipientSetting.setValue(String.valueOf(value));
        } else {
            notificationRecipientSetting.setValueMap((Map)value);
        }
        return notificationRecipientSetting;
    }

    public static Map<String, Object> getNotificationRecipientSettingsMap(NotificationQueueEntry notificationQueueEntry) {
        NotificationRecipient notificationRecipient = notificationQueueEntry.getNotificationRecipient();
        return NotificationRecipientSettingUtil.toMap(notificationRecipient.getNotificationRecipientSettings());
    }

    public static Map<String, Object> toMap(List<NotificationRecipientSetting> notificationRecipientSettings) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap recipientTypes = new HashMap();
        ListUtil.isNotEmptyForEach(notificationRecipientSettings, notificationRecipientSetting -> {
            String name = notificationRecipientSetting.getName();
            if (name.equals("bccType") || name.equals("ccType") || name.equals("toType")) {
                recipientTypes.put(name, notificationRecipientSetting.getValue());
            }
        });
        for (NotificationRecipientSetting notificationRecipientSetting2 : notificationRecipientSettings) {
            Map<Locale, String> value = notificationRecipientSetting2.getValue();
            if (StringUtil.equals((String)notificationRecipientSetting2.getName(), (String)"singleRecipient")) {
                value = GetterUtil.getBoolean((String)notificationRecipientSetting2.getValue());
            } else if (Validator.isXml((String)notificationRecipientSetting2.getValue())) {
                value = notificationRecipientSetting2.getValueMap();
            }
            String name = notificationRecipientSetting2.getName();
            if (!StringUtil.equals((String)((String)recipientTypes.get(NotificationRecipientSettingConstants.getRecipientTypeName(name))), (String)"role")) {
                map.put(name, value);
                continue;
            }
            List roles = (List)map.computeIfAbsent(name, key -> new ArrayList());
            roles.add(HashMapBuilder.put((Object)"roleName", (Object)String.valueOf(value)).build());
        }
        return map;
    }
}

