/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notification.type.util;

import com.liferay.notification.context.NotificationContext;
import com.liferay.notification.term.evaluator.NotificationTermEvaluator;
import com.liferay.notification.term.evaluator.NotificationTermEvaluatorTracker;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NotificationTypeUtil {
    private static final Pattern _termNamePattern = Pattern.compile("\\[%[^\\[%]+%\\]", 2);

    public static String evaluateTerms(String content, NotificationContext notificationContext, NotificationTermEvaluatorTracker notificationTermEvaluatorTracker) throws PortalException {
        if (Validator.isNull((String)content)) {
            return "";
        }
        ArrayList<String> termNames = new ArrayList<String>();
        Matcher matcher = _termNamePattern.matcher(content);
        while (matcher.find()) {
            termNames.add(matcher.group());
        }
        for (NotificationTermEvaluator notificationTermEvaluator : notificationTermEvaluatorTracker.getNotificationTermEvaluators(notificationContext.getClassName())) {
            for (String termName : termNames) {
                content = StringUtil.replace((String)content, (String)termName, (String)notificationTermEvaluator.evaluate(NotificationTermEvaluator.Context.CONTENT, notificationContext, termName));
            }
        }
        return content;
    }
}

